/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tuleap_git_branch_source;

import edu.umd.cs.findbugs.annotations.NonNull;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestSCMRevision;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapBranchSCMRevision;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapPullRequestSCMHead;
import org.jetbrains.annotations.NotNull;

public class TuleapPullRequestRevision
extends ChangeRequestSCMRevision<TuleapPullRequestSCMHead> {
    private final TuleapBranchSCMRevision origin;
    private final String targetHash;

    public TuleapPullRequestRevision(@NotNull TuleapPullRequestSCMHead head, @NotNull TuleapBranchSCMRevision target, @NonNull TuleapBranchSCMRevision origin) {
        super((SCMHead)head, (SCMRevision)target);
        this.origin = origin;
        this.targetHash = target.getHash();
    }

    public boolean equivalent(ChangeRequestSCMRevision<?> revision) {
        if (!(revision instanceof TuleapPullRequestRevision)) {
            return false;
        }
        TuleapPullRequestRevision tlpRevision = (TuleapPullRequestRevision)revision;
        return this.origin.equals(tlpRevision.getOrigin());
    }

    protected int _hashCode() {
        return this.origin.hashCode();
    }

    public SCMRevision getOrigin() {
        return this.origin;
    }

    public String getTargetHash() {
        return this.targetHash;
    }
}

