/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tuleap_git_branch_source;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import jenkins.model.Jenkins;
import org.apache.commons.jelly.JellyContext;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.stapler.Stapler;

public class TuleapLink
implements Action,
IconSpec {
    @NonNull
    private final String iconClassName;
    @NonNull
    private final String url;

    public TuleapLink(@NonNull String iconClassName, @NonNull String url) {
        this.iconClassName = iconClassName;
        this.url = url;
    }

    public String getIconFileName() {
        Icon icon;
        String iconClassName = this.getIconClassName();
        if (iconClassName != null && (icon = IconSet.icons.getIconByClassSpec((Object)(iconClassName + " icon-md"))) != null) {
            JellyContext ctx = new JellyContext();
            ctx.setVariable("resURL", (Object)(Stapler.getCurrentRequest().getContextPath() + Jenkins.RESOURCE_PATH));
            return icon.getQualifiedUrl(ctx);
        }
        return null;
    }

    public String getDisplayName() {
        return "Tuleap Project";
    }

    public String getUrlName() {
        return this.url;
    }

    public String getIconClassName() {
        return this.iconClassName;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TuleapLink that = (TuleapLink)o;
        if (!this.iconClassName.equals(that.iconClassName)) {
            return false;
        }
        return this.url.equals(that.url);
    }

    public int hashCode() {
        int result = this.iconClassName.hashCode();
        result = 31 * result + this.url.hashCode();
        return result;
    }
}

