/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tuleap_git_branch_source.config;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import io.jenkins.plugins.tuleap_api.client.GitApi;
import io.jenkins.plugins.tuleap_credentials.TuleapAccessToken;
import java.io.IOException;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapBranchSCMHead;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapPullRequestRevision;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapPullRequestSCMHead;
import org.jenkinsci.plugins.tuleap_git_branch_source.TuleapSCMSource;
import org.jenkinsci.plugins.tuleap_git_branch_source.config.TuleapConnector;
import org.jenkinsci.plugins.tuleap_git_branch_source.config.TuleapSCMFile;
import org.jenkinsci.plugins.tuleap_git_branch_source.helpers.TuleapApiRetriever;
import org.jetbrains.annotations.NotNull;

public class TuleapSCMFileSystem
extends SCMFileSystem {
    private GitApi gitApi;
    private final String repositoryId;
    private final String commitReference;
    private TuleapAccessToken tuleapAccessToken;

    protected TuleapSCMFileSystem(GitApi gitApi, String repositoryId, String commitReference, TuleapAccessToken tuleapAccessToken, SCMRevision rev) {
        super(rev);
        this.gitApi = gitApi;
        this.repositoryId = repositoryId;
        this.commitReference = commitReference;
        this.tuleapAccessToken = tuleapAccessToken;
    }

    public long lastModified() throws IOException, InterruptedException {
        return this.gitApi.getCommit(this.repositoryId, this.commitReference, this.tuleapAccessToken).getCommitDate().toInstant().toEpochMilli();
    }

    @NotNull
    public SCMFile getRoot() {
        return new TuleapSCMFile(this.gitApi, this.repositoryId, this.commitReference, this.tuleapAccessToken);
    }

    @Extension
    public static class BuilderImpl
    extends SCMFileSystem.Builder {
        public boolean supports(SCM source) {
            return false;
        }

        public boolean supports(SCMSource source) {
            return source instanceof TuleapSCMSource;
        }

        protected boolean supportsDescriptor(SCMDescriptor descriptor) {
            return false;
        }

        protected boolean supportsDescriptor(SCMSourceDescriptor descriptor) {
            return descriptor instanceof TuleapSCMSource.DescriptorImpl;
        }

        public SCMFileSystem build(@NotNull Item owner, @NotNull SCM scm, SCMRevision rev) throws IOException, InterruptedException {
            return null;
        }

        public SCMFileSystem build(@NonNull SCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision rev) {
            String repositoryId;
            String ref;
            GitApi gitApi = TuleapApiRetriever.getGitApi();
            TuleapSCMSource tuleapSCMSource = (TuleapSCMSource)source;
            TuleapAccessToken tuleapAccessToken = this.getAccessKey(tuleapSCMSource);
            if (head instanceof TuleapBranchSCMHead) {
                ref = head.getName();
                repositoryId = Integer.toString(tuleapSCMSource.getTuleapGitRepository().getId());
            } else if (head instanceof TuleapPullRequestSCMHead) {
                TuleapPullRequestSCMHead tlpHead = (TuleapPullRequestSCMHead)head;
                if (rev instanceof TuleapPullRequestRevision) {
                    ref = ((TuleapPullRequestSCMHead)head).getOriginName();
                    repositoryId = Integer.toString(((TuleapPullRequestSCMHead)head).getOriginRepositoryId());
                } else {
                    ref = tlpHead.getTarget().getName();
                    repositoryId = Integer.toString(tlpHead.getTargetRepositoryId());
                }
            } else {
                return null;
            }
            return new TuleapSCMFileSystem(gitApi, repositoryId, ref, tuleapAccessToken, rev);
        }

        private TuleapAccessToken getAccessKey(TuleapSCMSource source) {
            return TuleapConnector.lookupScanCredentials((Item)source.getOwner(), source.getApiBaseUri(), source.getCredentialsId());
        }
    }
}

