/*
 * Decompiled with CFR 0.152.
 */
package com.testquality.jenkins;

import com.testquality.jenkins.HttpException;
import com.testquality.jenkins.HttpTestQuality;
import com.testquality.jenkins.TestResult;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.json.JSONException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class TestQualityNotifier
extends Notifier {
    public static final String PLUGIN_SHORTNAME = "testquality-updater";
    private String project;
    private String plan;
    private String milestone;
    private String testResults;

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @DataBoundConstructor
    public TestQualityNotifier(String project, String plan, String milestone, String testResults) {
        this.project = project;
        this.plan = plan;
        this.milestone = milestone;
        this.testResults = testResults;
    }

    public String getProject() {
        return this.project;
    }

    public String getPlan() {
        return this.plan;
    }

    public String getMilestone() {
        return this.milestone;
    }

    public String getTestResults() {
        return this.testResults;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, AbortException {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new AbortException("no workspace for " + build);
        }
        try {
            String expandTestResults = build.getEnvironment((TaskListener)listener).expand(this.testResults);
            long buildTime = build.getTimestamp().getTimeInMillis();
            long timeOnMaster = System.currentTimeMillis();
            if (build.getResult() == Result.FAILURE) {
                return true;
            }
            listener.getLogger().println("Starting test upload to TestQuality for" + this.project);
            TestResult result = (TestResult)workspace.act((FilePath.FileCallable)new ParseResultCallable(expandTestResults, buildTime, timeOnMaster, this.getDescriptor().getUrl(), this.getDescriptor().getUsername(), this.getDescriptor().getPassword(), this.plan, this.milestone));
            long time = System.currentTimeMillis() - timeOnMaster;
            if (result.total > 0) {
                listener.getLogger().println(String.format("Of %d tests, %d passed, %d failed, %d skipped, tests ran in %s seconds", result.total, result.passed, result.failed, result.blocked, result.time));
            }
            if (!StringUtils.isBlank((String)result.run_url)) {
                listener.hyperlink(result.run_url, "View Test Run Result (" + result.run_url + ")\n");
            }
            listener.getLogger().println(String.format("TestQuality Upload finished in %sms", time));
        }
        catch (InterruptedException e) {
            listener.getLogger().println("Interupted, " + e.getMessage());
            return false;
        }
        catch (HttpException | IOException | JSONException e) {
            listener.getLogger().println(e.getMessage());
            return false;
        }
        return true;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public static final String DEFAULT_URL = "https://api.testquality.com";
        public static final String NO_CONNECTION = "Please fill in connection details in Manage Jenkins -> Configure System";
        public static final String DISPLAY_NAME = "TestQuality Updater";
        private static final Logger LOGGER = Logger.getLogger("TestQualityPlugin.log");
        private String url = "https://api.testquality.com";
        private String username;
        private String password;

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return DISPLAY_NAME;
        }

        public String getHelpFile() {
            return "/plugin/testquality-updater/help/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doTestConnection(@QueryParameter(value="url") String url, @QueryParameter(value="username") String username, @QueryParameter(value="password") String password) {
            try {
                HttpTestQuality testQuality = new HttpTestQuality();
                testQuality.connect(url, username, password);
                return FormValidation.ok((String)"Successful Connection");
            }
            catch (HttpException | IOException | JSONException e) {
                return FormValidation.error((String)("Connection error : " + e.getMessage()));
            }
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.url = formData.getString("url");
            this.username = formData.getString("username");
            this.password = formData.getString("password");
            this.save();
            return super.configure(req, formData);
        }

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public FormValidation doCheckProject(@QueryParameter(value="project") String project) throws IOException {
            if (StringUtils.isBlank((String)this.url) || StringUtils.isBlank((String)this.username) || StringUtils.isBlank((String)this.password)) {
                return FormValidation.error((String)NO_CONNECTION);
            }
            HttpTestQuality testQuality = new HttpTestQuality();
            try {
                testQuality.connect(this.url, this.username, this.password);
            }
            catch (HttpException | IOException | JSONException e) {
                return FormValidation.error((String)("Connection error : " + e.getMessage()));
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillProjectItems(@QueryParameter(value="project") String savedProject) throws FormValidation {
            ListBoxModel items = new ListBoxModel();
            if (StringUtils.isBlank((String)this.url) || StringUtils.isBlank((String)this.username) || StringUtils.isBlank((String)this.password)) {
                return items;
            }
            if (StringUtils.isBlank((String)savedProject)) {
                items.add((Object)new ListBoxModel.Option("", "", true));
            }
            HttpTestQuality testQuality = new HttpTestQuality();
            try {
                testQuality.connect(this.url, this.username, this.password);
                testQuality.getList("project", "PJ", items, savedProject, "");
            }
            catch (HttpException | IOException | JSONException e) {
                LOGGER.log(Level.SEVERE, "ERROR: Filling List Box, " + e.getMessage(), e);
            }
            return items;
        }

        public ListBoxModel doFillPlanItems(@QueryParameter String project, @QueryParameter(value="plan") String savedPlan) {
            ListBoxModel items = new ListBoxModel();
            if (StringUtils.isBlank((String)project) || project.trim().equals("-1")) {
                return items;
            }
            HttpTestQuality testQuality = new HttpTestQuality();
            try {
                testQuality.connect(this.url, this.username, this.password);
                testQuality.getList("plan", "P", items, savedPlan, project);
            }
            catch (HttpException | IOException | JSONException e) {
                LOGGER.log(Level.SEVERE, "ERROR: Filling List Box, " + e.getMessage(), e);
            }
            return items;
        }

        public ListBoxModel doFillMilestoneItems(@QueryParameter String project, @QueryParameter(value="milestone") String savedMilestone) {
            ListBoxModel items = new ListBoxModel();
            if (StringUtils.isBlank((String)project) || project.trim().equals(NO_CONNECTION) || project.trim().equals("-1")) {
                return items;
            }
            items.add("Optionally Pick Milestone", "-1");
            HttpTestQuality testQuality = new HttpTestQuality();
            try {
                testQuality.connect(this.url, this.username, this.password);
                testQuality.getList("milestone", "M", items, savedMilestone, project);
            }
            catch (HttpException | IOException | JSONException e) {
                LOGGER.log(Level.SEVERE, "ERROR: Filling List Box, " + e.getMessage(), e);
            }
            return items;
        }

        public FormValidation doCheckTestResults(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            if (project == null) {
                return FormValidation.ok();
            }
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }
    }

    private static final class ParseResultCallable
    extends MasterToSlaveFileCallable<TestResult> {
        private final String testResults;
        private final long buildTime;
        private final long nowMaster;
        private final String url;
        private final String username;
        private final String password;
        private final String plan;
        private final String milestone;

        private ParseResultCallable(String testResults, long buildTime, long nowMaster, String url, String username, String password, String plan, String milestone) {
            this.testResults = testResults;
            this.buildTime = buildTime;
            this.nowMaster = nowMaster;
            this.url = url;
            this.username = username;
            this.password = password;
            this.plan = plan;
            this.milestone = milestone;
        }

        public TestResult invoke(File ws, VirtualChannel channel) throws IOException {
            long nowSlave = System.currentTimeMillis();
            ArrayList<File> listFiles = new ArrayList<File>();
            FileSet fs = Util.createFileSet((File)ws, (String)this.testResults);
            DirectoryScanner ds = fs.getDirectoryScanner();
            TestResult result = new TestResult();
            String[] files = ds.getIncludedFiles();
            if (files.length > 0) {
                File baseDir = ds.getBasedir();
                for (String value : files) {
                    File reportFile = new File(baseDir, value);
                    if (this.buildTime + (nowSlave - this.nowMaster) - 3000L > reportFile.lastModified()) continue;
                    listFiles.add(reportFile);
                }
                HttpTestQuality testQuality = new HttpTestQuality();
                testQuality.connect(this.url, this.username, this.password);
                return testQuality.uploadFiles(listFiles, this.plan, this.milestone);
            }
            return result;
        }
    }
}

