/*
 * Decompiled with CFR 0.152.
 */
package com.testquality.jenkins;

import com.testquality.jenkins.HttpException;
import com.testquality.jenkins.TestResult;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpTestQuality {
    private final OkHttpClient client = new OkHttpClient.Builder().readTimeout(600L, TimeUnit.SECONDS).writeTimeout(600L, TimeUnit.SECONDS).build();
    private String tqUrl;
    private String authorization;

    public boolean isConnected() {
        if (this.authorization != null) {
            return StringUtils.isBlank((String)this.authorization);
        }
        return false;
    }

    public void connect(String url, String username, String password) throws IOException, JSONException, HttpException {
        this.tqUrl = url;
        FormBody formBody = new FormBody.Builder().add("grant_type", "password").add("client_id", "2").add("client_secret", "93MBS86X7JrK4Mrr1mk4PKfo6b1zRVx9Mrmx0nTa").add("username", username).add("password", password).build();
        Request.Builder builder = new Request.Builder().url(url + "/api/oauth/access_token").post((RequestBody)formBody);
        Request request = builder.build();
        long start = System.nanoTime();
        Response response = this.client.newCall(request).execute();
        long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        if (!response.isSuccessful()) {
            throw new HttpException(response, time, response.body().string());
        }
        String json = response.body().string();
        JSONObject obj = new JSONObject(json);
        if (obj.has("verification_ended_at")) {
            throw new HttpException("User account needs to be verified, please check inbox.");
        }
        this.authorization = "Bearer " + obj.getString("access_token");
    }

    public void getList(String type, String keyPrefix, ListBoxModel items, String selectedId, String projectId) throws IOException, JSONException, HttpException {
        String url = this.tqUrl + "/api/" + type;
        if (!StringUtils.isBlank((String)projectId)) {
            url = url + "?project_id=" + projectId;
        }
        Request.Builder builder = new Request.Builder().url(url).header("Accept", "application/json").addHeader("Authorization", this.authorization);
        Request request = builder.build();
        long start = System.nanoTime();
        Response response = this.client.newCall(request).execute();
        long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        if (!response.isSuccessful()) {
            throw new HttpException(response, time, response.body().string());
        }
        JSONObject obj = new JSONObject(response.body().string());
        JSONArray arr = obj.getJSONArray("data");
        for (int i = 0; i < arr.length(); ++i) {
            String name = arr.getJSONObject(i).getString("name");
            int key = arr.getJSONObject(i).getInt("key");
            int id = arr.getJSONObject(i).getInt("id");
            String idStr = Integer.toString(id);
            items.add((Object)new ListBoxModel.Option(String.format("%s%s %s", keyPrefix, key, name), idStr, idStr.equals(selectedId)));
        }
    }

    public TestResult uploadFiles(List<File> files, String planId, String milestoneId) throws IOException, HttpException {
        if (files.isEmpty()) {
            throw new HttpException("No files selected for upload");
        }
        MediaType mediaType = MediaType.parse((String)"text/xml");
        String url = this.tqUrl + "/api/plan/" + planId + "/junit_xml";
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder();
        requestBodyBuilder.setType(MultipartBody.FORM);
        if (!StringUtils.isBlank((String)milestoneId) && !milestoneId.equals("-1")) {
            requestBodyBuilder.addFormDataPart("milestone_id", milestoneId);
        }
        for (File file : files) {
            RequestBody fileBody = RequestBody.create((MediaType)mediaType, (File)file);
            requestBodyBuilder.addFormDataPart("files[]", file.getName(), fileBody);
        }
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().header("Accept", "application/json").addHeader("Authorization", this.authorization).url(url).post((RequestBody)requestBody).build();
        long start = System.nanoTime();
        Response response = this.client.newCall(request).execute();
        long time = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        if (!response.isSuccessful()) {
            throw new HttpException(response, time, response.body().string());
        }
        TestResult result = new TestResult();
        JSONObject obj = new JSONObject(response.body().string());
        if (obj.has("total")) {
            result.total = obj.getInt("total");
        }
        if (obj.has("passed")) {
            result.passed = obj.getInt("passed");
        }
        if (obj.has("failed")) {
            result.failed = obj.getInt("failed");
        }
        if (obj.has("blocked")) {
            result.blocked = obj.getInt("blocked");
        }
        if (obj.has("time")) {
            result.time = obj.getString("time");
        }
        if (obj.has("run_url")) {
            result.run_url = obj.getString("run_url");
        }
        return result;
    }
}

