/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink.result;

import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionStatus;
import com.tupilabs.testng.parser.Class;
import com.tupilabs.testng.parser.Suite;
import com.tupilabs.testng.parser.Test;
import com.tupilabs.testng.parser.TestMethod;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.testlink.TestLinkSite;
import hudson.plugins.testlink.result.AbstractTestNGResultSeeker;
import hudson.plugins.testlink.result.ResultSeekerDescriptor;
import hudson.plugins.testlink.result.ResultSeekerException;
import hudson.plugins.testlink.result.TestCaseWrapper;
import hudson.plugins.testlink.util.Messages;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class TestNGMethodNameDataProviderNameResultSeeker
extends AbstractTestNGResultSeeker {
    private static final long serialVersionUID = -3337191837294608305L;
    private final String dataProviderNameKeyCustomField;

    @DataBoundConstructor
    public TestNGMethodNameDataProviderNameResultSeeker(String includePattern, String keyCustomField, boolean attachTestNGXML, boolean markSkippedTestAsBlocked, String dataProviderNameKeyCustomField, boolean includeNotes) {
        super(includePattern, keyCustomField, attachTestNGXML, markSkippedTestAsBlocked, includeNotes);
        this.dataProviderNameKeyCustomField = dataProviderNameKeyCustomField;
    }

    public String getDataProviderNameKeyCustomField() {
        return this.dataProviderNameKeyCustomField;
    }

    @Override
    public void seek(TestCaseWrapper[] automatedTestCases, AbstractBuild<?, ?> build, Launcher launcher, final BuildListener listener, TestLinkSite testlink) throws ResultSeekerException {
        listener.getLogger().println(Messages.Results_TestNG_LookingForTestMethodDataProvider());
        try {
            List suites = (List)build.getWorkspace().act((FilePath.FileCallable)new MasterToSlaveFileCallable<List<Suite>>(){
                private static final long serialVersionUID = 1L;
                private List<Suite> suites = new ArrayList<Suite>();

                public List<Suite> invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
                    String[] xmls;
                    for (String xml : xmls = TestNGMethodNameDataProviderNameResultSeeker.this.scan(workspace, TestNGMethodNameDataProviderNameResultSeeker.this.includePattern, listener)) {
                        File input = new File(workspace, xml);
                        List suitz = TestNGMethodNameDataProviderNameResultSeeker.this.getParser().parse(input);
                        for (Suite suite : suitz) {
                            this.suites.add(suite);
                        }
                    }
                    return this.suites;
                }
            });
            for (Suite suite : suites) {
                for (Test test : suite.getTests()) {
                    for (Class clazz : test.getClasses()) {
                        for (TestMethod method : clazz.getTestMethods()) {
                            for (TestCaseWrapper automatedTestCase : automatedTestCases) {
                                String qualifiedName = clazz.getName() + '#' + method.getName();
                                String dataProviderName = method.getDataProvider();
                                String[] commaSeparatedValues = automatedTestCase.getKeyCustomFieldValues(this.keyCustomField);
                                String dataProviderValue = automatedTestCase.getKeyCustomFieldValue(this.dataProviderNameKeyCustomField);
                                for (String value : commaSeparatedValues) {
                                    if (!qualifiedName.equals(value) || !dataProviderName.equals(dataProviderValue)) continue;
                                    ExecutionStatus status = this.getExecutionStatus(method);
                                    if (status != ExecutionStatus.NOT_RUN) {
                                        automatedTestCase.addCustomFieldAndStatus(value, status);
                                    }
                                    if (this.isIncludeNotes()) {
                                        String notes = this.getTestNGNotes(method);
                                        automatedTestCase.appendNotes(notes);
                                    }
                                    this.handleResult(automatedTestCase, build, listener, testlink, status, suite);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ResultSeekerException(e);
        }
        catch (InterruptedException e) {
            throw new ResultSeekerException(e);
        }
    }

    private ExecutionStatus getExecutionStatus(TestMethod method) {
        if (StringUtils.isNotBlank((String)method.getStatus())) {
            if (method.getStatus().equals("FAIL")) {
                return ExecutionStatus.FAILED;
            }
            if (method.getStatus().equals("SKIP")) {
                if (this.isMarkSkippedTestAsBlocked()) {
                    return ExecutionStatus.BLOCKED;
                }
                return ExecutionStatus.NOT_RUN;
            }
        }
        return ExecutionStatus.PASSED;
    }

    private String getTestNGNotes(TestMethod method) {
        StringBuilder notes = new StringBuilder();
        notes.append(Messages.Results_TestNG_NotesForMethodsWithDataProviders(method.getName(), method.getIsConfig(), method.getSignature(), method.getStatus(), method.getDurationMs(), method.getStartedAt(), method.getFinishedAt(), method.getDataProvider()));
        return notes.toString();
    }

    @Extension
    public static class DescriptorImpl
    extends ResultSeekerDescriptor {
        public String getDisplayName() {
            return "TestNG method name and data provider name";
        }
    }
}

