/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink.result;

import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionStatus;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.plugins.testlink.TestLinkSite;
import hudson.plugins.testlink.result.AbstractJUnitResultSeeker;
import hudson.plugins.testlink.result.ResultSeekerDescriptor;
import hudson.plugins.testlink.result.ResultSeekerException;
import hudson.plugins.testlink.result.TestCaseWrapper;
import hudson.plugins.testlink.util.Messages;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.JUnitParser;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class JUnitMethodNameResultSeeker
extends AbstractJUnitResultSeeker {
    private static final long serialVersionUID = -9198823056268332288L;

    @DataBoundConstructor
    public JUnitMethodNameResultSeeker(String includePattern, String keyCustomField, boolean attachJUnitXML, boolean includeNotes) {
        super(includePattern, keyCustomField, attachJUnitXML, includeNotes);
    }

    @Override
    public void seek(TestCaseWrapper[] automatedTestCases, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, TestLinkSite testlink) throws ResultSeekerException {
        listener.getLogger().println(Messages.Results_JUnit_LookingForTestMethods());
        try {
            JUnitParser parser = new JUnitParser(false);
            TestResult testResult = parser.parse(this.includePattern, build, launcher, (TaskListener)listener);
            for (SuiteResult suiteResult : testResult.getSuites()) {
                for (CaseResult caseResult : suiteResult.getCases()) {
                    String methodName = caseResult.getClassName() + "#" + caseResult.getName();
                    for (TestCaseWrapper automatedTestCase : automatedTestCases) {
                        String[] commaSeparatedValues;
                        for (String value : commaSeparatedValues = automatedTestCase.getKeyCustomFieldValues(this.keyCustomField)) {
                            if (caseResult.isSkipped() || !methodName.equals(value)) continue;
                            ExecutionStatus status = this.getExecutionStatus(caseResult);
                            automatedTestCase.addCustomFieldAndStatus(value, status);
                            if (this.isIncludeNotes()) {
                                String notes = this.getJUnitNotes(caseResult, build.number);
                                automatedTestCase.appendNotes(notes);
                            }
                            super.handleResult(automatedTestCase, build, listener, testlink, suiteResult);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ResultSeekerException(e);
        }
        catch (InterruptedException e) {
            throw new ResultSeekerException(e);
        }
    }

    private ExecutionStatus getExecutionStatus(CaseResult caseResult) {
        if (caseResult.isSkipped()) {
            return ExecutionStatus.NOT_RUN;
        }
        if (caseResult.isPassed()) {
            return ExecutionStatus.PASSED;
        }
        return ExecutionStatus.FAILED;
    }

    private String getJUnitNotes(CaseResult testCase, int buildNumber) {
        StringBuilder notes = new StringBuilder();
        notes.append(Messages.Results_JUnit_NotesForTestMethod(testCase.getName(), testCase.getClassName(), testCase.getSkipCount(), testCase.getFailCount(), testCase.getSuiteResult() != null ? testCase.getSuiteResult().getTimestamp() : null));
        notes.append("\nBuild no : " + buildNumber);
        if (null != testCase.getErrorDetails()) {
            notes.append("\nError Message : " + testCase.getErrorDetails());
        }
        return notes.toString();
    }

    @Extension
    public static class DescriptorImpl
    extends ResultSeekerDescriptor {
        public String getDisplayName() {
            return "JUnit method name";
        }
    }
}

