/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink.result;

import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionStatus;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.util.TestLinkAPIException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.testlink.TestLinkSite;
import hudson.plugins.testlink.result.ResultSeeker;
import hudson.plugins.testlink.result.ResultSeekerException;
import hudson.plugins.testlink.result.TestCaseWrapper;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.MasterToSlaveFileCallable;
import org.tap4j.consumer.TapConsumer;
import org.tap4j.consumer.TapConsumerFactory;
import org.tap4j.model.Directive;
import org.tap4j.model.Plan;
import org.tap4j.model.TestResult;
import org.tap4j.model.TestSet;
import org.tap4j.producer.TapProducer;
import org.tap4j.producer.TapProducerFactory;
import org.tap4j.util.DirectiveValues;

public abstract class AbstractTAPFileNameResultSeeker
extends ResultSeeker {
    private static final long serialVersionUID = 3068999690225092293L;
    protected static final String TEXT_PLAIN_CONTENT_TYPE = "text/plain";
    private boolean attachTAPStream = false;
    private boolean attachYAMLishAttachments = false;
    private Boolean compareFullPath = false;

    public AbstractTAPFileNameResultSeeker(String includePattern, String keyCustomField, boolean attachTAPStream, boolean attachYAMLishAttachments, boolean includeNotes, Boolean compareFullPath) {
        super(includePattern, keyCustomField, includeNotes);
        this.attachTAPStream = attachTAPStream;
        this.attachYAMLishAttachments = attachYAMLishAttachments;
        this.compareFullPath = compareFullPath;
    }

    public void setAttachTAPStream(boolean attachTAPStream) {
        this.attachTAPStream = attachTAPStream;
    }

    public boolean isAttachTAPStream() {
        return this.attachTAPStream;
    }

    public void setAttachYAMLishAttachments(boolean attachYAMLishAttachments) {
        this.attachYAMLishAttachments = attachYAMLishAttachments;
    }

    public boolean isAttachYAMLishAttachments() {
        return this.attachYAMLishAttachments;
    }

    public Boolean isCompareFullPath() {
        if (this.compareFullPath == null) {
            this.compareFullPath = false;
        }
        return this.compareFullPath;
    }

    public Boolean getCompareFullPath() {
        return this.isCompareFullPath();
    }

    public void setCompareFullPath(Boolean compareFullPath) {
        this.compareFullPath = compareFullPath;
    }

    @Override
    public void seek(TestCaseWrapper[] automatedTestCases, AbstractBuild<?, ?> build, Launcher launcher, final BuildListener listener, TestLinkSite testlink) throws ResultSeekerException {
        try {
            Map testSets = (Map)build.getWorkspace().act((FilePath.FileCallable)new MasterToSlaveFileCallable<Map<String, TestSet>>(){
                private static final long serialVersionUID = 1L;
                private Map<String, TestSet> testSets;

                public Map<String, TestSet> invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
                    String[] tapFiles = AbstractTAPFileNameResultSeeker.this.scan(workspace, AbstractTAPFileNameResultSeeker.this.includePattern, listener);
                    this.testSets = new HashMap<String, TestSet>(tapFiles.length);
                    for (String tapFile : tapFiles) {
                        File input = new File(workspace, tapFile);
                        TapConsumer tapConsumer = TapConsumerFactory.makeTap13YamlConsumer();
                        TestSet testSet = tapConsumer.load(input);
                        this.testSets.put(tapFile, testSet);
                    }
                    return this.testSets;
                }
            });
            for (String key : testSets.keySet()) {
                for (TestCaseWrapper automatedTestCase : automatedTestCases) {
                    String[] commaSeparatedValues;
                    for (String value : commaSeparatedValues = automatedTestCase.getKeyCustomFieldValues(this.keyCustomField)) {
                        int extensionIndex;
                        int lastIndex;
                        String tapFileNameWithoutExtension = key;
                        int leftIndex = 0;
                        if (!this.isCompareFullPath().booleanValue() && (lastIndex = tapFileNameWithoutExtension.lastIndexOf(File.separator)) > 0) {
                            leftIndex = lastIndex + 1;
                        }
                        if ((extensionIndex = tapFileNameWithoutExtension.lastIndexOf(46)) != -1) {
                            tapFileNameWithoutExtension = tapFileNameWithoutExtension.substring(leftIndex, tapFileNameWithoutExtension.lastIndexOf(46));
                        }
                        if (!tapFileNameWithoutExtension.equals(value)) continue;
                        this.updateTestCase(testSets, key, automatedTestCase, value, build, listener, testlink);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ResultSeekerException(e);
        }
        catch (InterruptedException e) {
            throw new ResultSeekerException(e);
        }
    }

    protected void updateTestCase(Map<String, TestSet> testSets, String key, TestCaseWrapper automatedTestCase, String value, AbstractBuild<?, ?> build, BuildListener listener, TestLinkSite testlink) {
        ExecutionStatus status = this.getExecutionStatus(testSets.get(key));
        automatedTestCase.addCustomFieldAndStatus(value, status);
        if (this.isIncludeNotes()) {
            String notes = this.getTapNotes(testSets.get(key));
            automatedTestCase.appendNotes(notes);
        }
        this.handleResult(automatedTestCase, build, listener, testlink, status, testSets, key);
    }

    protected void handleResult(TestCaseWrapper automatedTestCase, AbstractBuild<?, ?> build, BuildListener listener, TestLinkSite testlink, ExecutionStatus status, final Map<String, TestSet> testSets, final String key) {
        if (automatedTestCase.getExecutionStatus(this.keyCustomField) != ExecutionStatus.NOT_RUN) {
            String platform = this.retrievePlatform(testSets.get(key));
            automatedTestCase.setPlatform(platform);
            try {
                int executionId = testlink.updateTestCase(automatedTestCase);
                if (executionId > 0 && this.isAttachTAPStream()) {
                    final String remoteWs = build.getWorkspace().getRemote();
                    List attachments = (List)build.getWorkspace().act((FilePath.FileCallable)new MasterToSlaveFileCallable<List<Attachment>>(){
                        private static final long serialVersionUID = -5411683541842375558L;
                        List<Attachment> attachments = new ArrayList<Attachment>();

                        public List<Attachment> invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                            File reportFile = new File(remoteWs, key);
                            Attachment attachment = new Attachment();
                            attachment.setContent(AbstractTAPFileNameResultSeeker.this.getBase64FileContent(reportFile));
                            attachment.setDescription(reportFile.getName());
                            attachment.setFileName(reportFile.getName());
                            attachment.setFileSize(Long.valueOf(reportFile.length()));
                            attachment.setFileType(AbstractTAPFileNameResultSeeker.TEXT_PLAIN_CONTENT_TYPE);
                            attachment.setTitle(reportFile.getName());
                            this.attachments.add(attachment);
                            if (AbstractTAPFileNameResultSeeker.this.isAttachYAMLishAttachments()) {
                                this.attachments.addAll(AbstractTAPFileNameResultSeeker.this.retrieveListOfTapAttachments((TestSet)testSets.get(key)));
                            }
                            return this.attachments;
                        }
                    });
                    for (Attachment attachment : attachments) {
                        testlink.uploadAttachment(executionId, attachment);
                    }
                }
            }
            catch (TestLinkAPIException te) {
                build.setResult(Result.UNSTABLE);
                te.printStackTrace(listener.getLogger());
            }
            catch (IOException e) {
                build.setResult(Result.UNSTABLE);
                e.printStackTrace(listener.getLogger());
            }
            catch (InterruptedException e) {
                build.setResult(Result.UNSTABLE);
                e.printStackTrace(listener.getLogger());
            }
        }
    }

    private ExecutionStatus getExecutionStatus(TestSet testSet) {
        ExecutionStatus status = ExecutionStatus.PASSED;
        if (this.isSkipped(testSet)) {
            status = ExecutionStatus.BLOCKED;
        } else if (this.isFailed(testSet)) {
            status = ExecutionStatus.FAILED;
        }
        return status;
    }

    private boolean isSkipped(TestSet testSet) {
        boolean r = false;
        if (testSet.getPlan().isSkip().booleanValue()) {
            r = true;
        } else {
            for (TestResult testResult : testSet.getTestResults()) {
                Directive directive = testResult.getDirective();
                if (directive == null || directive.getDirectiveValue() != DirectiveValues.SKIP) continue;
                r = true;
                break;
            }
        }
        return r;
    }

    private boolean isFailed(TestSet testSet) {
        boolean r = false;
        if (testSet.containsNotOk().booleanValue() || testSet.containsBailOut().booleanValue()) {
            r = true;
        } else {
            for (TestResult testResult : testSet.getTestResults()) {
                Directive directive = testResult.getDirective();
                if (directive == null || directive.getDirectiveValue() != DirectiveValues.TODO) continue;
                r = true;
                break;
            }
        }
        return r;
    }

    protected String getTapNotes(TestSet testSet) {
        TapProducer producer = TapProducerFactory.makeTap13YamlProducer();
        return producer.dump(testSet);
    }

    protected String retrievePlatform(TestSet tapTestSet) {
        String platform;
        block1: {
            TestResult testResult;
            Map diagnostic;
            platform = null;
            Plan plan = tapTestSet.getPlan();
            Map planDiagnostic = plan.getDiagnostic();
            platform = this.extractPlatform(planDiagnostic);
            if (platform != null) break block1;
            Iterator iterator = tapTestSet.getTestResults().iterator();
            while (iterator.hasNext() && (platform = this.extractPlatform(diagnostic = (testResult = (TestResult)iterator.next()).getDiagnostic())) == null) {
            }
        }
        return platform;
    }

    private String extractPlatform(Map<String, Object> diagnostic) {
        Map extensionsInfo;
        Object testlink;
        String platform = null;
        Object extensions = diagnostic.get("extensions");
        if (extensions != null && extensions instanceof Map && (testlink = (extensionsInfo = (Map)extensions).get("TestLink")) != null && testlink instanceof Map) {
            Map testLinkInfo = (Map)testlink;
            Object o = testLinkInfo.get("Platform");
            if (o == null) {
                o = testLinkInfo.get("platform");
            }
            if (o != null && o instanceof String) {
                platform = (String)o;
            }
        }
        return platform;
    }

    List<Attachment> retrieveListOfTapAttachments(TestSet testSet) throws IOException {
        LinkedList<Attachment> attachments = new LinkedList<Attachment>();
        Plan plan = testSet.getPlan();
        Map diagnostic = plan.getDiagnostic();
        this.extractAttachments(attachments, diagnostic);
        for (TestResult testResult : testSet.getTestResults()) {
            this.extractAttachments(attachments, testResult.getDiagnostic());
        }
        return attachments;
    }

    protected void extractAttachments(List<Attachment> attachments, Map<String, Object> diagnostic) throws IOException {
        Map extensionsMap;
        Object files;
        Object extensions = diagnostic.get("extensions");
        if (extensions != null && extensions instanceof Map && (files = (extensionsMap = (Map)extensions).get("Files")) != null && files instanceof Map) {
            Map filesMap = (Map)files;
            Set filesMapEntrySet = filesMap.entrySet();
            Iterator iterator = filesMapEntrySet.iterator();
            while (iterator != null && iterator.hasNext()) {
                Map.Entry filesMapEntry = iterator.next();
                Object entryObject = filesMapEntry.getValue();
                if (entryObject == null || !(entryObject instanceof Map)) continue;
                Map entryObjectMap = (Map)entryObject;
                Object oFileContent = entryObjectMap.get("File-Content");
                if (oFileContent != null) {
                    String fileContent = "" + oFileContent;
                    Attachment attachment = new Attachment();
                    attachment.setContent(fileContent);
                    try {
                        attachment.setFileSize(Long.valueOf(Long.parseLong("" + entryObjectMap.get("File-Size"))));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    attachment.setFileName("" + entryObjectMap.get("File-Name"));
                    attachment.setTitle("" + entryObjectMap.get("File-Title"));
                    attachment.setDescription("" + entryObjectMap.get("File-Description"));
                    attachment.setFileType("" + entryObjectMap.get("File-Type"));
                    attachments.add(attachment);
                    continue;
                }
                Object fileLocation = entryObjectMap.get("File-Location");
                String fileLocationText = "" + fileLocation;
                File file = new File(fileLocationText);
                if (!file.exists()) continue;
                Attachment attachment = new Attachment();
                Object oContent = entryObjectMap.get("File-Content");
                if (oContent != null) {
                    attachment.setContent("" + oContent);
                    try {
                        attachment.setFileSize(Long.valueOf(Long.parseLong("" + entryObjectMap.get("File-Size"))));
                    }
                    catch (NumberFormatException nfe) {
                        attachment.setFileSize(Long.valueOf(file.length()));
                    }
                } else {
                    String fileContent = this.getBase64FileContent(file);
                    attachment.setContent(fileContent);
                    attachment.setFileSize(Long.valueOf(file.length()));
                }
                attachment.setFileName("" + entryObjectMap.get("File-Name"));
                attachment.setTitle("" + entryObjectMap.get("File-Title"));
                attachment.setDescription("" + entryObjectMap.get("File-Description"));
                attachment.setFileType("" + entryObjectMap.get("File-Location"));
                attachments.add(attachment);
            }
        }
    }
}

