/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink.result;

import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionStatus;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.util.TestLinkAPIException;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.testlink.TestLinkSite;
import hudson.plugins.testlink.result.ResultSeeker;
import hudson.plugins.testlink.result.TestCaseWrapper;
import hudson.plugins.testlink.util.Messages;
import hudson.remoting.VirtualChannel;
import hudson.tasks.junit.SuiteResult;
import java.io.File;
import java.io.IOException;
import jenkins.MasterToSlaveFileCallable;

public abstract class AbstractJUnitResultSeeker
extends ResultSeeker {
    private static final long serialVersionUID = -5345177768201402707L;
    private static final String TEXT_XML_CONTENT_TYPE = "text/xml";
    private boolean attachJUnitXML = false;

    public AbstractJUnitResultSeeker(String includePattern, String keyCustomField, boolean attachJunitXML, boolean includeNotes) {
        super(includePattern, keyCustomField, includeNotes);
        this.attachJUnitXML = attachJunitXML;
    }

    public void setAttachJUnitXML(boolean attachJUnitXML) {
        this.attachJUnitXML = attachJUnitXML;
    }

    public boolean isAttachJUnitXML() {
        return this.attachJUnitXML;
    }

    protected void handleResult(TestCaseWrapper automatedTestCase, AbstractBuild<?, ?> build, BuildListener listener, TestLinkSite testlink, final SuiteResult suiteResult) {
        if (automatedTestCase.getExecutionStatus(this.keyCustomField) != ExecutionStatus.NOT_RUN) {
            try {
                listener.getLogger().println(Messages.TestLinkBuilder_Update_AutomatedTestCases());
                int executionId = testlink.updateTestCase(automatedTestCase);
                if (executionId > 0 && this.isAttachJUnitXML()) {
                    Attachment attachment = (Attachment)build.getWorkspace().act((FilePath.FileCallable)new MasterToSlaveFileCallable<Attachment>(){
                        private static final long serialVersionUID = -5411683541842375558L;

                        public Attachment invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                            File reportFile = new File(suiteResult.getFile());
                            Attachment attachment = new Attachment();
                            attachment.setContent(AbstractJUnitResultSeeker.this.getBase64FileContent(reportFile));
                            attachment.setDescription(reportFile.getName());
                            attachment.setFileName(reportFile.getName());
                            attachment.setFileSize(Long.valueOf(reportFile.length()));
                            attachment.setFileType(AbstractJUnitResultSeeker.TEXT_XML_CONTENT_TYPE);
                            attachment.setTitle(reportFile.getName());
                            return attachment;
                        }
                    });
                    testlink.uploadAttachment(executionId, attachment);
                }
            }
            catch (TestLinkAPIException te) {
                build.setResult(Result.UNSTABLE);
                te.printStackTrace(listener.getLogger());
            }
            catch (IOException e) {
                build.setResult(Result.UNSTABLE);
                e.printStackTrace(listener.getLogger());
            }
            catch (InterruptedException e) {
                build.setResult(Result.UNSTABLE);
                e.printStackTrace(listener.getLogger());
            }
        }
    }
}

