/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink;

import br.eti.kinoshita.testlinkjavaapi.TestLinkAPI;
import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionStatus;
import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionType;
import br.eti.kinoshita.testlinkjavaapi.constants.ResponseDetails;
import br.eti.kinoshita.testlinkjavaapi.constants.TestCaseDetails;
import br.eti.kinoshita.testlinkjavaapi.model.Attachment;
import br.eti.kinoshita.testlinkjavaapi.model.Build;
import br.eti.kinoshita.testlinkjavaapi.model.CustomField;
import br.eti.kinoshita.testlinkjavaapi.model.Platform;
import br.eti.kinoshita.testlinkjavaapi.model.ReportTCResultResponse;
import br.eti.kinoshita.testlinkjavaapi.model.TestCase;
import br.eti.kinoshita.testlinkjavaapi.model.TestPlan;
import br.eti.kinoshita.testlinkjavaapi.model.TestProject;
import hudson.plugins.testlink.Report;
import hudson.plugins.testlink.result.TestCaseWrapper;
import java.util.ArrayList;

public class TestLinkSite {
    protected final TestLinkAPI api;
    protected final TestProject testProject;
    protected final TestPlan testPlan;
    protected final Platform platform;
    protected final Build build;
    protected final Report report;

    public TestLinkSite(TestLinkAPI api, TestProject testProject, TestPlan testPlan, Build build) {
        this(api, testProject, testPlan, null, build);
    }

    public TestLinkSite(TestLinkAPI api, TestProject testProject, TestPlan testPlan, Platform platform, Build build) {
        this.api = api;
        this.testProject = testProject;
        this.testPlan = testPlan;
        this.platform = platform;
        this.build = build;
        this.report = build != null ? new Report(build.getId() == null ? 0 : build.getId(), build.getName()) : new Report(0, null);
    }

    public TestLinkAPI getApi() {
        return this.api;
    }

    public TestProject getTestProject() {
        return this.testProject;
    }

    public TestPlan getTestPlan() {
        return this.testPlan;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public Build getBuild() {
        return this.build;
    }

    public Report getReport() {
        return this.report;
    }

    public TestCase[] getAutomatedTestCases(String[] customFieldsNames) {
        TestCase[] testCases = this.api.getTestCasesForTestPlan(this.getTestPlan().getId(), null, null, null, null, null, null, null, ExecutionType.AUTOMATED, Boolean.TRUE, TestCaseDetails.FULL);
        ArrayList<TestCase> filteredTestcases = new ArrayList<TestCase>();
        for (TestCase testCase : testCases) {
            testCase.setTestProjectId(this.getTestProject().getId());
            testCase.setExecutionStatus(ExecutionStatus.NOT_RUN);
            if (customFieldsNames != null) {
                for (String customFieldName : customFieldsNames) {
                    CustomField customField = this.api.getTestCaseCustomFieldDesignValue(testCase.getId(), null, testCase.getVersion(), testCase.getTestProjectId(), customFieldName, ResponseDetails.FULL);
                    testCase.getCustomFields().add(customField);
                }
            }
            if (this.platform != null && !testCase.getPlatform().getName().equals(this.platform.getName())) continue;
            filteredTestcases.add(testCase);
        }
        return filteredTestcases.toArray(new TestCase[filteredTestcases.size()]);
    }

    public TestPlan getTestPlanWithCustomFields(String[] customFieldNames) {
        TestPlan testPlan = this.getTestPlan();
        for (String customFieldName : customFieldNames) {
            CustomField customField = this.api.getTestPlanCustomFieldDesignValue(testPlan.getId(), this.getTestProject().getId(), customFieldName, ResponseDetails.FULL);
            testPlan.getCustomFields().add(customField);
        }
        return testPlan;
    }

    public int updateTestCase(TestCaseWrapper testCase) {
        int executionId = 0;
        Integer platformId = null;
        String platformName = null;
        if (testCase.getPlatform() == null) {
            if (this.platform != null) {
                platformId = this.platform.getId();
                platformName = this.platform.getName();
            }
        } else {
            platformName = testCase.getPlatform();
        }
        if (testCase.getExecutionStatus() != null && !ExecutionStatus.NOT_RUN.equals((Object)testCase.getExecutionStatus())) {
            ReportTCResultResponse reportTCResultResponse = this.api.reportTCResult(testCase.getId(), testCase.getInternalId(), this.testPlan.getId(), testCase.getExecutionStatus(), null, this.build.getId(), this.build.getName(), testCase.getNotes(), null, null, platformId, platformName, null, null);
            switch (testCase.getExecutionStatus()) {
                case PASSED: {
                    this.report.setPassed(this.report.getPassed() + 1);
                    break;
                }
                case FAILED: {
                    this.report.setFailed(this.report.getFailed() + 1);
                    break;
                }
                case BLOCKED: {
                    this.report.setBlocked(this.report.getBlocked() + 1);
                    break;
                }
            }
            executionId = reportTCResultResponse.getExecutionId();
        }
        return executionId;
    }

    public Attachment uploadAttachment(int executionId, Attachment attachment) {
        return this.api.uploadExecutionAttachment(Integer.valueOf(executionId), attachment.getTitle(), attachment.getDescription(), attachment.getFileName(), attachment.getFileType(), attachment.getContent());
    }
}

