/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testlink;

import com.tupilabs.testng.parser.Class;
import com.tupilabs.testng.parser.ParserException;
import com.tupilabs.testng.parser.Suite;
import com.tupilabs.testng.parser.Test;
import com.tupilabs.testng.parser.TestMethod;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Items;
import hudson.plugins.testlink.TestLinkBuilder;
import hudson.plugins.testlink.TestLinkInstallation;
import hudson.plugins.testlink.result.ResultSeeker;
import hudson.plugins.testlink.util.Messages;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class TestLinkBuilderDescriptor
extends BuildStepDescriptor<Builder> {
    public final java.lang.Class<TestLinkBuilder> testLinkBuildType = TestLinkBuilder.class;
    private static final String DISPLAY_NAME = "Invoke TestLink";
    private volatile TestLinkInstallation[] installations = new TestLinkInstallation[0];

    public TestLinkBuilderDescriptor() {
        super(TestLinkBuilder.class);
        this.load();
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public TestLinkInstallation[] getInstallations() {
        return this.installations;
    }

    public TestLinkInstallation getInstallationByTestLinkName(String testLinkName) {
        TestLinkInstallation installation = null;
        if (this.installations != null && this.installations.length > 0) {
            for (TestLinkInstallation tempInst : this.installations) {
                if (!tempInst.getName().equals(testLinkName)) continue;
                return tempInst;
            }
        }
        return installation;
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        this.installations = req.bindParametersToList(TestLinkInstallation.class, "TestLink.").toArray(new TestLinkInstallation[0]);
        this.save();
        return true;
    }

    public List<Descriptor<? extends BuildStep>> getApplicableBuildSteps(AbstractProject<?, ?> p) {
        return TestLinkBuilderDescriptor.getBuildSteps();
    }

    public List<Descriptor<? extends ResultSeeker>> getApplicableResultSeekers(AbstractProject<?, ?> p) {
        LinkedList<Descriptor<? extends ResultSeeker>> list = new LinkedList<Descriptor<? extends ResultSeeker>>();
        for (Descriptor rs : ResultSeeker.all()) {
            list.add((Descriptor<? extends ResultSeeker>)rs);
        }
        return list;
    }

    public static List<Descriptor<? extends BuildStep>> getBuildSteps() {
        ArrayList<Descriptor<? extends BuildStep>> list = new ArrayList<Descriptor<? extends BuildStep>>();
        TestLinkBuilderDescriptor.addTo((List<? extends Descriptor<? extends BuildStep>>)Builder.all(), list);
        TestLinkBuilderDescriptor.addTo((List<? extends Descriptor<? extends BuildStep>>)Publisher.all(), list);
        return list;
    }

    private static void addTo(List<? extends Descriptor<? extends BuildStep>> source, List<Descriptor<? extends BuildStep>> list) {
        for (Descriptor<? extends BuildStep> descriptor : source) {
            BuildStepDescriptor bsd;
            if (!(descriptor instanceof BuildStepDescriptor) || !(bsd = (BuildStepDescriptor)descriptor).isApplicable(FreeStyleProject.class)) continue;
            list.add(descriptor);
        }
    }

    public FormValidation doCheckMandatory(@QueryParameter String value) {
        FormValidation returnValue = FormValidation.ok();
        if (StringUtils.isBlank((String)value)) {
            returnValue = FormValidation.error((String)Messages.TestLinkBuilder_MandatoryProperty());
        }
        return returnValue;
    }

    public boolean isApplicable(java.lang.Class<? extends AbstractProject> jobType) {
        return Boolean.TRUE;
    }

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void addAliases() {
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.testlink.testng.Suite", Suite.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.testlink.testng.Test", Test.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.testlink.testng.TestMethod", TestMethod.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.testlink.testng.Class", Class.class);
        Items.XSTREAM2.addCompatibilityAlias("hudson.plugins.testlink.testng.ParserException", ParserException.class);
        Items.XSTREAM2.alias("hudson.plugins.testlink.testng.Class.list", LinkedList.class, LinkedHashSet.class);
    }
}

