/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.templateproject;

import hudson.Extension;
import hudson.Launcher;
import hudson.console.HyperlinkNote;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.DependencyGraph;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Project;
import hudson.model.Run;
import hudson.plugins.templateproject.TemplateUtils;
import hudson.security.AccessControlled;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.tasks.Messages;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.DependencyDeclarer;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ProxyBuildEnvironment
extends BuildWrapper
implements DependencyDeclarer {
    private final String projectName;

    @DataBoundConstructor
    public ProxyBuildEnvironment(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getExpandedProjectName(AbstractBuild<?, ?> build) {
        return TemplateUtils.getExpandedProjectName(this.projectName, build);
    }

    public AbstractProject<?, ?> getProject() {
        return TemplateUtils.getProject(this.projectName, null);
    }

    public List<BuildWrapper> getProjectBuildWrappers(AbstractBuild<?, ?> build) {
        AbstractProject<?, ?> p = TemplateUtils.getProject(this.getProjectName(), build);
        if (p instanceof Project) {
            return ((Project)p).getBuildWrappersList();
        }
        if (p instanceof MatrixProject) {
            return ((MatrixProject)p).getBuildWrappersList();
        }
        return Collections.emptyList();
    }

    public final void buildDependencyGraph(AbstractProject project, DependencyGraph graph) {
        Item item = Hudson.getInstance().getItemByFullName(this.getProjectName());
        AbstractProject templateProject = (AbstractProject)Hudson.getInstance().getItem(this.getProjectName());
        if (item instanceof Project) {
            for (BuildWrapper wrapper : this.getProjectBuildWrappers(null)) {
                if (!(wrapper instanceof DependencyDeclarer)) continue;
                ((DependencyDeclarer)wrapper).buildDependencyGraph(project, graph);
            }
        }
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        AbstractProject<?, ?> p = TemplateUtils.getProject(this.getProjectName(), build);
        listener.getLogger().println("[TemplateProject] Getting environment from: " + HyperlinkNote.encodeTo((String)('/' + p.getUrl()), (String)p.getFullDisplayName()));
        for (BuildWrapper builder : this.getProjectBuildWrappers(build)) {
            builder.setUp(build, launcher, listener);
        }
        listener.getLogger().println("[TemplateProject] Successfully setup environment from: '" + p.getFullDisplayName() + "'");
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                return true;
            }
        };
    }

    public void preCheckout(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        AbstractProject<?, ?> p = TemplateUtils.getProject(this.getProjectName(), build);
        listener.getLogger().println("[TemplateProject] Starting pre-checkout from: " + HyperlinkNote.encodeTo((String)('/' + p.getUrl()), (String)p.getFullDisplayName()));
        for (BuildWrapper builder : this.getProjectBuildWrappers(build)) {
            builder.preCheckout(build, launcher, listener);
        }
        listener.getLogger().println("[TemplateProject] Successfully performed pre-checkout from: '" + p.getFullDisplayName() + "'");
    }

    public Launcher decorateLauncher(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        for (BuildWrapper builder : this.getProjectBuildWrappers(build)) {
            launcher = builder.decorateLauncher(build, launcher, listener);
        }
        return launcher;
    }

    public OutputStream decorateLogger(AbstractBuild build, OutputStream logger) throws IOException, InterruptedException, Run.RunnerAbortedException {
        for (BuildWrapper builder : this.getProjectBuildWrappers(build)) {
            logger = builder.decorateLogger(build, logger);
        }
        return logger;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject project) {
        ArrayList actions = new ArrayList();
        for (BuildWrapper wrapper : this.getProjectBuildWrappers(null)) {
            actions.addAll(wrapper.getProjectActions(project));
        }
        return actions;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return "Use build environment from another project";
        }

        public boolean isApplicable(AbstractProject<?, ?> jobType) {
            return true;
        }

        public FormValidation doCheckProjectName(@AncestorInPath AccessControlled anc, @QueryParameter String value) {
            if (!anc.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            Item item = Hudson.getInstance().getItemByFullName(value, Item.class);
            if (item == null) {
                return FormValidation.error((String)Messages.BuildTrigger_NoSuchProject((Object)value, (Object)AbstractProject.findNearest((String)value).getName()));
            }
            if (!(item instanceof Project) && !(item instanceof MatrixProject)) {
                return FormValidation.error((String)Messages.BuildTrigger_NotBuildable((Object)value));
            }
            return FormValidation.ok();
        }
    }
}

