/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.PrintWriter;
import jenkins.model.Jenkins;

public class SwarmLauncher
extends JNLPLauncher {
    public SwarmLauncher() {
        super(false);
    }

    public void afterDisconnect(SlaveComputer computer, TaskListener listener) {
        super.afterDisconnect(computer, listener);
        Slave node = computer.getNode();
        if (node != null) {
            try {
                Jenkins.get().removeNode((Node)node);
            }
            catch (IOException e) {
                Functions.printStackTrace((Throwable)e, (PrintWriter)listener.error("Failed to remove node \"%s\".", new Object[]{node.getNodeName()}));
            }
        } else {
            listener.getLogger().printf("Node for computer \"%s\" appears to have been removed already.%n", computer);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        @NonNull
        public String getDisplayName() {
            return "Launch Swarm agent";
        }
    }
}

