/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.EphemeralNode;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwarmSlave
extends Slave
implements EphemeralNode {
    private static final JNLPLauncher SELF_CLEANUP_LAUNCHER = new JNLPLauncher(){

        public void afterDisconnect(SlaveComputer computer, TaskListener listener) {
            try {
                Jenkins.getInstance().removeNode((Node)computer.getNode());
            }
            catch (IOException e) {
                e.printStackTrace(listener.error(e.getMessage()));
            }
        }
    };

    public SwarmSlave(String name, String nodeDescription, String remoteFS, String numExecutors, String label) throws IOException, Descriptor.FormException {
        super(name, nodeDescription, remoteFS, numExecutors, Node.Mode.NORMAL, label, (ComputerLauncher)SELF_CLEANUP_LAUNCHER, RetentionStrategy.NOOP, Collections.emptyList());
    }

    @DataBoundConstructor
    public SwarmSlave(String name, String nodeDescription, String remoteFS, String numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties) throws Descriptor.FormException, IOException {
        super(name, nodeDescription, remoteFS, Util.tryParseNumber((String)numExecutors, (Number)1).intValue(), mode, labelString, launcher, retentionStrategy, nodeProperties);
    }

    public Node asNode() {
        return this;
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "Swarm Slave";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

