/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.Future;
import hudson.remoting.RequestAbortedException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.RoleChecker;

public abstract class PingThread
extends Thread {
    private final Channel channel;
    private final long timeout;
    private final long interval;
    private static final Logger LOGGER = Logger.getLogger(PingThread.class.getName());

    public PingThread(Channel channel, long timeout, long interval) {
        super("Ping thread for channel " + channel);
        this.channel = channel;
        this.timeout = timeout;
        this.interval = interval;
        this.setDaemon(true);
        this.setUncaughtExceptionHandler((t, e) -> {
            LOGGER.log(Level.SEVERE, "Uncaught exception in PingThread " + t, e);
            this.onDead(e);
        });
    }

    public PingThread(Channel channel, long interval) {
        this(channel, 240000L, interval);
    }

    public PingThread(Channel channel) {
        this(channel, 600000L);
    }

    @Override
    public void run() {
        try {
            block4: while (true) {
                long nextCheck = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.interval);
                this.ping();
                while (true) {
                    long diff;
                    if ((diff = nextCheck - System.nanoTime()) <= 0L) continue block4;
                    Thread.sleep(TimeUnit.NANOSECONDS.toMillis(diff));
                }
                break;
            }
        }
        catch (ChannelClosedException e) {
            LOGGER.fine(this.getName() + " is closed. Terminating");
        }
        catch (IOException e) {
            this.onDead(e);
        }
        catch (InterruptedException e) {
            LOGGER.fine(this.getName() + " is interrupted. Terminating");
        }
    }

    private void ping() throws IOException, InterruptedException {
        LOGGER.log(Level.FINE, "pinging {0}", this.channel.getName());
        Future<Void> f = this.channel.callAsync(new Ping());
        long start = System.currentTimeMillis();
        long end = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.timeout);
        long remaining = end - System.nanoTime();
        while (true) {
            LOGGER.log(Level.FINE, "waiting {0}s on {1}", new Object[]{TimeUnit.NANOSECONDS.toSeconds(remaining), this.channel.getName()});
            try {
                f.get(Math.max(1L, remaining), TimeUnit.NANOSECONDS);
                LOGGER.log(Level.FINE, "ping succeeded on {0}", this.channel.getName());
                return;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RequestAbortedException) {
                    return;
                }
                this.onDead(e);
                return;
            }
            catch (TimeoutException timeoutException) {
                if ((remaining = end - System.nanoTime()) > 0L) continue;
                this.onDead(new TimeoutException("Ping started at " + start + " hasn't completed by " + System.currentTimeMillis()));
                return;
            }
            break;
        }
    }

    @Deprecated
    protected abstract void onDead();

    protected void onDead(Throwable diagnosis) {
        this.onDead();
    }

    private static final class Ping
    implements Callable<Void, IOException> {
        private static final long serialVersionUID = 1L;

        private Ping() {
        }

        @Override
        public Void call() throws IOException {
            return null;
        }

        @Override
        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }
}

