/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Callable;
import hudson.remoting.Capability;
import hudson.remoting.Channel;
import hudson.remoting.ChannelProperty;
import hudson.remoting.ChunkedCommandTransport;
import hudson.remoting.ClassFilter;
import hudson.remoting.ClassicCommandTransport;
import hudson.remoting.CommandTransport;
import hudson.remoting.FlightRecorderInputStream;
import hudson.remoting.JarCache;
import hudson.remoting.ObjectInputStreamEx;
import hudson.remoting.SocketChannelStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.remoting.CallableDecorator;
import org.jenkinsci.remoting.Role;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

public class ChannelBuilder {
    private static final Logger LOGGER = Logger.getLogger(ChannelBuilder.class.getName());
    private final String name;
    private final ExecutorService executors;
    private ClassLoader base = this.getClass().getClassLoader();
    private Channel.Mode mode = Channel.Mode.NEGOTIATE;
    private Capability capability = new Capability();
    private OutputStream header;
    @CheckForNull
    private JarCache jarCache;
    private List<CallableDecorator> decorators = new ArrayList<CallableDecorator>();
    private boolean arbitraryCallableAllowed = true;
    private boolean remoteClassLoadingAllowed = true;
    private final Hashtable<Object, Object> properties = new Hashtable();
    private ClassFilter filter = ClassFilter.DEFAULT;

    public ChannelBuilder(String name, ExecutorService executors) {
        this.name = name;
        this.executors = executors;
    }

    public String getName() {
        return this.name;
    }

    public ExecutorService getExecutors() {
        return this.executors;
    }

    public ChannelBuilder withBaseLoader(ClassLoader base) {
        if (base == null) {
            base = this.getClass().getClassLoader();
        }
        this.base = base;
        return this;
    }

    public ClassLoader getBaseLoader() {
        return this.base;
    }

    public ChannelBuilder withMode(Channel.Mode mode) {
        this.mode = mode;
        return this;
    }

    public Channel.Mode getMode() {
        return this.mode;
    }

    public ChannelBuilder withCapability(Capability capability) {
        this.capability = capability;
        return this;
    }

    public Capability getCapability() {
        return this.capability;
    }

    public ChannelBuilder withHeaderStream(OutputStream header) {
        this.header = header;
        return this;
    }

    public OutputStream getHeaderStream() {
        return this.header;
    }

    @Deprecated
    public ChannelBuilder withRestricted(boolean restricted) {
        this.withArbitraryCallableAllowed(!restricted);
        this.withRemoteClassLoadingAllowed(!restricted);
        return this;
    }

    @Deprecated
    public boolean isRestricted() {
        return !this.isArbitraryCallableAllowed() || !this.isRemoteClassLoadingAllowed();
    }

    public ChannelBuilder withArbitraryCallableAllowed(boolean b) {
        this.arbitraryCallableAllowed = b;
        return this;
    }

    public boolean isArbitraryCallableAllowed() {
        return this.arbitraryCallableAllowed;
    }

    public ChannelBuilder withRemoteClassLoadingAllowed(boolean b) {
        this.remoteClassLoadingAllowed = b;
        return this;
    }

    public boolean isRemoteClassLoadingAllowed() {
        return this.remoteClassLoadingAllowed;
    }

    public ChannelBuilder withJarCache(@Nonnull JarCache jarCache) {
        this.jarCache = jarCache;
        return this;
    }

    public ChannelBuilder withJarCacheOrDefault(@CheckForNull JarCache jarCache) throws IOException {
        this.jarCache = jarCache != null ? jarCache : JarCache.getDefault();
        return this;
    }

    public ChannelBuilder withoutJarCache() {
        this.jarCache = null;
        return this;
    }

    @CheckForNull
    public JarCache getJarCache() {
        return this.jarCache;
    }

    public ChannelBuilder with(CallableDecorator decorator) {
        this.decorators.add(decorator);
        return this;
    }

    public List<CallableDecorator> getDecorators() {
        return this.decorators;
    }

    public ChannelBuilder withRoles(Role ... roles) {
        return this.withRoles(Arrays.asList(roles));
    }

    public ChannelBuilder withRoles(final Collection<? extends Role> actual) {
        return this.withRoleChecker(new RoleChecker(){

            @Override
            public void check(RoleSensitive subject, @Nonnull Collection<Role> expected) {
                if (!actual.containsAll(expected)) {
                    ArrayList<Role> c = new ArrayList<Role>(expected);
                    c.removeAll(actual);
                    throw new SecurityException("Unexpected role: " + c);
                }
            }
        });
    }

    public ChannelBuilder withRoleChecker(final RoleChecker checker) {
        return this.with(new CallableDecorator(){

            @Override
            public <V, T extends Throwable> Callable<V, T> userRequest(Callable<V, T> op, Callable<V, T> stem) {
                try {
                    stem.checkRoles(checker);
                }
                catch (AbstractMethodError e) {
                    checker.check((RoleSensitive)stem, Role.UNKNOWN);
                }
                return stem;
            }
        });
    }

    public ChannelBuilder withProperty(Object key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    public <T> ChannelBuilder withProperty(ChannelProperty<T> key, T value) {
        return this.withProperty((Object)key, (Object)value);
    }

    public Map<Object, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public ChannelBuilder withClassFilter(ClassFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException();
        }
        this.filter = filter;
        return this;
    }

    public ClassFilter getClassFilter() {
        return this.filter;
    }

    public Channel build(InputStream is, OutputStream os) throws IOException {
        return new Channel(this, this.negotiate(is, os));
    }

    public Channel build(Socket s) throws IOException {
        return this.build(new BufferedInputStream(SocketChannelStream.in(s)), new BufferedOutputStream(SocketChannelStream.out(s)));
    }

    public Channel build(SocketChannel s) throws IOException {
        return this.build(SocketChannelStream.in(s), SocketChannelStream.out(s));
    }

    public Channel build(CommandTransport transport) throws IOException {
        return new Channel(this, transport);
    }

    protected CommandTransport negotiate(InputStream is, OutputStream os) throws IOException {
        LOGGER.log(Level.FINER, "Sending capability preamble: {0}", this.capability);
        this.capability.writePreamble(os);
        Channel.Mode mode = this.getMode();
        if (mode != Channel.Mode.NEGOTIATE) {
            LOGGER.log(Level.FINER, "Sending mode preamble: {0}", (Object)mode);
            os.write(mode.preamble);
            os.flush();
        } else {
            LOGGER.log(Level.FINER, "Awaiting mode preamble...");
        }
        Channel.Mode[] modes = new Channel.Mode[]{Channel.Mode.BINARY, Channel.Mode.TEXT};
        byte[][] preambles = new byte[][]{Channel.Mode.BINARY.preamble, Channel.Mode.TEXT.preamble, Capability.PREAMBLE};
        int[] ptr = new int[3];
        Capability cap = new Capability(0L);
        while (true) {
            int ch;
            if ((ch = is.read()) == -1) {
                throw new EOFException("unexpected stream termination");
            }
            for (int i = 0; i < preambles.length; ++i) {
                byte[] preamble = preambles[i];
                if (preamble[ptr[i]] == ch) {
                    int n = i;
                    ptr[n] = ptr[n] + 1;
                    if (ptr[n] != preamble.length) continue;
                    switch (i) {
                        case 0: 
                        case 1: {
                            LOGGER.log(Level.FINER, "Received mode preamble: {0}", (Object)modes[i]);
                            if (mode == Channel.Mode.NEGOTIATE) {
                                mode = modes[i];
                                LOGGER.log(Level.FINER, "Sending agreed mode preamble: {0}", (Object)mode);
                                os.write(mode.preamble);
                                os.flush();
                            } else if (modes[i] != mode) {
                                throw new IOException("Protocol negotiation failure");
                            }
                            LOGGER.log(Level.FINE, "Channel name {0} negotiated mode {1} with capability {2}", new Object[]{this.name, mode, cap});
                            return this.makeTransport(is, os, mode, cap);
                        }
                        case 2: {
                            cap = Capability.read(is);
                            LOGGER.log(Level.FINER, "Received capability preamble: {0}", cap);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected preamble byte #" + i + ". Only " + preambles.length + " bytes are supported");
                        }
                    }
                    ptr[i] = 0;
                    continue;
                }
                ptr[i] = 0;
            }
            if (this.header == null) continue;
            this.header.write(ch);
        }
    }

    protected CommandTransport makeTransport(InputStream is, OutputStream os, Channel.Mode mode, Capability cap) throws IOException {
        FlightRecorderInputStream fis = new FlightRecorderInputStream(is);
        if (cap.supportsChunking()) {
            return new ChunkedCommandTransport(cap, mode.wrap(fis), mode.wrap(os), os);
        }
        ObjectOutputStream oos = new ObjectOutputStream(mode.wrap(os));
        oos.flush();
        return new ClassicCommandTransport(new ObjectInputStreamEx(mode.wrap(fis), this.getBaseLoader(), this.getClassFilter()), oos, fis, os, cap);
    }
}

