/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.plugins.swarm.RestrictiveEntityResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class XmlUtils {
    private static final Logger logger = LogManager.getLogManager().getLogger(XmlUtils.class.getName());

    @NonNull
    public static Document parse(@NonNull InputStream stream) throws IOException, SAXException {
        DocumentBuilder docBuilder;
        try {
            docBuilder = XmlUtils.newDocumentBuilderFactory().newDocumentBuilder();
            docBuilder.setEntityResolver(RestrictiveEntityResolver.INSTANCE);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unexpected error creating DocumentBuilder.", e);
        }
        return docBuilder.parse(stream);
    }

    private static DocumentBuilderFactory newDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        XmlUtils.setDocumentBuilderFactoryFeature(documentBuilderFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        XmlUtils.setDocumentBuilderFactoryFeature(documentBuilderFactory, "http://xml.org/sax/features/external-general-entities", false);
        XmlUtils.setDocumentBuilderFactoryFeature(documentBuilderFactory, "http://xml.org/sax/features/external-parameter-entities", false);
        XmlUtils.setDocumentBuilderFactoryFeature(documentBuilderFactory, "http://apache.org/xml/features/disallow-doctype-decl", true);
        return documentBuilderFactory;
    }

    private static void setDocumentBuilderFactoryFeature(DocumentBuilderFactory documentBuilderFactory, String feature, boolean state) {
        try {
            documentBuilderFactory.setFeature(feature, state);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, String.format("Failed to set the XML Document Builder factory feature %s to %s", feature, state), e);
        }
    }
}

