/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import org.jenkinsci.remoting.util.ByteBufferQueue;

public class FastByteBufferQueueInputStream
extends InputStream {
    private final ByteBufferQueue queue;
    private final int length;
    private int pos;

    public FastByteBufferQueueInputStream(ByteBufferQueue queue, int length) {
        this.queue = queue;
        this.length = length;
    }

    @Override
    public int read() throws IOException {
        return this.pos++ >= this.length ? -1 : this.queue.get() & 0xFF;
    }

    @Override
    public int read(@NonNull byte[] b, int off, int len) throws IOException {
        int rem = this.length - this.pos;
        if (rem <= 0) {
            return -1;
        }
        int read = this.queue.get(b, off, Math.min(len, rem));
        if (read <= 0) {
            return -1;
        }
        this.pos += read;
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.pos >= this.length) {
            return -1L;
        }
        if ((long)this.pos + n >= (long)this.length) {
            n = this.length - this.pos;
        }
        long skipped = this.queue.skip(n);
        this.pos = (int)((long)this.pos + skipped);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.pos >= this.length ? -1 : this.length - this.pos;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

