/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.swarm;

import hudson.plugins.swarm.ConfigurationException;
import hudson.plugins.swarm.ModeOptionHandler;
import hudson.plugins.swarm.Options;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Objects;
import org.kohsuke.args4j.Option;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;

public class YamlConfig {
    private static final Options defaultOptions = new Options();
    private final Yaml yaml;

    public YamlConfig() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setEnumCaseSensitive(false);
        this.yaml = new Yaml(new Constructor(Options.class, loaderOptions));
    }

    public Options loadOptions(InputStream inputStream) throws ConfigurationException {
        Options options = this.yaml.loadAs(inputStream, Options.class);
        this.checkForbidden(options.config != null, "config");
        this.checkForbidden(options.password != null, "password");
        for (Field field : Options.class.getDeclaredFields()) {
            this.checkField(options, field);
        }
        if (!ModeOptionHandler.accepts(options.mode)) {
            throw new ConfigurationException("'mode' has an invalid value: '" + options.mode + "'");
        }
        return options;
    }

    private void checkForbidden(boolean hasValue, String name) throws ConfigurationException {
        if (hasValue) {
            throw new ConfigurationException("'" + name + "' is not allowed in configuration file");
        }
    }

    private boolean isSet(Options options, Field field) throws NoSuchFieldException, IllegalAccessException {
        Object defaultValue = Options.class.getDeclaredField(field.getName()).get(defaultOptions);
        return !Objects.equals(field.get(options), defaultValue);
    }

    private void checkField(Options options, Field field) throws ConfigurationException {
        try {
            Option annotation = field.getAnnotation(Option.class);
            if (annotation != null) {
                if (annotation.required() && !this.isSet(options, field)) {
                    throw new ConfigurationException("'" + field.getName() + "' is required");
                }
                if (annotation.help()) {
                    this.checkForbidden(this.isSet(options, field), field.getName());
                }
                this.checkForbids(options, field, annotation.forbids());
                this.checkDepends(options, field, annotation.depends());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void checkDepends(Options options, Field field, String[] depends) throws NoSuchFieldException, IllegalAccessException, ConfigurationException {
        for (String dependsOnOption : depends) {
            Field dependsOn = this.fieldForOption(dependsOnOption);
            if (!this.isSet(options, field) || this.isSet(options, dependsOn)) continue;
            throw new ConfigurationException("'" + field.getName() + "' depends on '" + dependsOn.getName() + "'");
        }
    }

    private void checkForbids(Options options, Field field, String[] forbids) throws NoSuchFieldException, IllegalAccessException, ConfigurationException {
        for (String forbidden : forbids) {
            Field forbiddenField = this.fieldForOption(forbidden);
            if (!this.isSet(options, field) || !this.isSet(options, forbiddenField)) continue;
            throw new ConfigurationException("'" + field.getName() + "' can not be used with '" + forbiddenField.getName() + "'");
        }
    }

    private Field fieldForOption(String option) throws NoSuchFieldException {
        return Options.class.getDeclaredField(option.replace("-", ""));
    }
}

