/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.util.ExecutorServiceUtils;

public class SingleLaneExecutorService
extends AbstractExecutorService {
    private final ExecutorService base;
    private final Queue<Runnable> tasks = new LinkedBlockingQueue<Runnable>();
    private boolean scheduled;
    private boolean shuttingDown;
    private boolean shutDown;
    private static final Logger LOGGER = Logger.getLogger(SingleLaneExecutorService.class.getName());
    private final Runnable runner = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SingleLaneExecutorService singleLaneExecutorService;
            try {
                ((Runnable)SingleLaneExecutorService.this.tasks.peek()).run();
                singleLaneExecutorService = SingleLaneExecutorService.this;
            }
            catch (Throwable throwable) {
                SingleLaneExecutorService singleLaneExecutorService2 = SingleLaneExecutorService.this;
                synchronized (singleLaneExecutorService2) {
                    SingleLaneExecutorService.this.tasks.remove();
                    assert (SingleLaneExecutorService.this.scheduled);
                    if (!SingleLaneExecutorService.this.tasks.isEmpty()) {
                        try {
                            ExecutorServiceUtils.submitAsync(SingleLaneExecutorService.this.base, this);
                        }
                        catch (ExecutorServiceUtils.ExecutionRejectedException ex) {
                            LOGGER.log(Level.SEVERE, String.format("Base executor service %s has rejected the queue task %s. Propagating the RuntimeException to the caller.", ex.getExecutorServiceDisplayName(), ex.getRunnableDisplayName()), ex);
                            throw ExecutorServiceUtils.createRuntimeException("Base executor service has rejected the task from the queue", ex);
                        }
                    } else {
                        SingleLaneExecutorService.this.scheduled = false;
                        if (SingleLaneExecutorService.this.shuttingDown) {
                            SingleLaneExecutorService.this.shutDown = true;
                            SingleLaneExecutorService.this.notifyAll();
                        }
                    }
                }
                throw throwable;
            }
            synchronized (singleLaneExecutorService) {
                SingleLaneExecutorService.this.tasks.remove();
                assert (SingleLaneExecutorService.this.scheduled);
                if (!SingleLaneExecutorService.this.tasks.isEmpty()) {
                    try {
                        ExecutorServiceUtils.submitAsync(SingleLaneExecutorService.this.base, this);
                    }
                    catch (ExecutorServiceUtils.ExecutionRejectedException ex) {
                        LOGGER.log(Level.SEVERE, String.format("Base executor service %s has rejected the queue task %s. Propagating the RuntimeException to the caller.", ex.getExecutorServiceDisplayName(), ex.getRunnableDisplayName()), ex);
                        throw ExecutorServiceUtils.createRuntimeException("Base executor service has rejected the task from the queue", ex);
                    }
                } else {
                    SingleLaneExecutorService.this.scheduled = false;
                    if (SingleLaneExecutorService.this.shuttingDown) {
                        SingleLaneExecutorService.this.shutDown = true;
                        SingleLaneExecutorService.this.notifyAll();
                    }
                }
            }
        }
    };

    public SingleLaneExecutorService(ExecutorService base) {
        this.base = base;
    }

    @Override
    public synchronized void shutdown() {
        this.shuttingDown = true;
        if (this.tasks.isEmpty()) {
            this.shutDown = true;
        }
    }

    @Override
    public synchronized List<Runnable> shutdownNow() {
        this.shutDown = true;
        this.shuttingDown = true;
        LinkedList<Runnable> all = new LinkedList<Runnable>(this.tasks);
        this.tasks.clear();
        return all;
    }

    @Override
    public synchronized boolean isShutdown() {
        return this.shuttingDown;
    }

    @Override
    public synchronized boolean isTerminated() {
        return this.shutDown;
    }

    @Override
    public synchronized boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long now = System.nanoTime();
        long end = now + unit.toNanos(timeout);
        while (!this.isTerminated() && end - now > 0L) {
            this.wait(TimeUnit.NANOSECONDS.toMillis(end - now));
            now = System.nanoTime();
        }
        return this.isTerminated();
    }

    @Override
    public synchronized void execute(Runnable command) {
        if (this.shuttingDown) {
            throw new ExecutorServiceUtils.FatalRejectedExecutionException("Cannot execute the command " + command + ". The executor service is shutting down");
        }
        this.tasks.add(command);
        if (!this.scheduled) {
            this.scheduled = true;
            try {
                ExecutorServiceUtils.submitAsync(this.base, this.runner);
            }
            catch (ExecutorServiceUtils.ExecutionRejectedException ex) {
                throw new RejectedExecutionException("Base executor service " + this.base + " has rejected the task " + command, ex);
            }
        }
    }
}

