/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.RemoteClassLoader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.CheckForNull;
import org.jenkinsci.remoting.SerializableOnlyOverRemoting;

public class ClassLoaderHolder
implements SerializableOnlyOverRemoting {
    @CheckForNull
    private transient ClassLoader classLoader;
    private static final long serialVersionUID = 1L;

    public ClassLoaderHolder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoaderHolder() {
    }

    @CheckForNull
    public ClassLoader get() {
        return this.classLoader;
    }

    public void set(@CheckForNull ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        RemoteClassLoader.IClassLoader proxy = (RemoteClassLoader.IClassLoader)ois.readObject();
        this.classLoader = proxy == null ? null : this.getChannelForSerialization().importedClassLoaders.get(proxy);
    }

    @SuppressFBWarnings(value={"DMI_NONSERIALIZABLE_OBJECT_WRITTEN"}, justification="RemoteClassLoader.export() produces a serializable wrapper class")
    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.classLoader == null) {
            oos.writeObject(null);
        } else {
            RemoteClassLoader.IClassLoader proxy = RemoteClassLoader.export(this.classLoader, this.getChannelForSerialization());
            oos.writeObject(proxy);
        }
    }
}

