/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.Command;
import hudson.remoting.CommandTransport;
import hudson.remoting.ObjectInputStreamEx;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.remoting.util.AnonymousClassWarnings;

public abstract class AbstractByteArrayCommandTransport
extends CommandTransport {
    protected Channel channel;
    private static final Logger LOGGER = Logger.getLogger(AbstractByteArrayCommandTransport.class.getName());

    public abstract void writeBlock(Channel var1, byte[] var2) throws IOException;

    public abstract void setup(@Nonnull ByteArrayReceiver var1);

    @Override
    public final void setup(final Channel channel, final CommandTransport.CommandReceiver receiver) {
        this.channel = channel;
        this.setup(new ByteArrayReceiver(){

            @Override
            public void handle(byte[] payload) {
                try {
                    Command cmd = Command.readFrom(channel, new ObjectInputStreamEx(new ByteArrayInputStream(payload), channel.baseClassLoader, channel.classFilter));
                    receiver.handle(cmd);
                    channel.notifyRead(cmd, payload.length);
                }
                catch (IOException | ClassNotFoundException e) {
                    LOGGER.log(Level.WARNING, "Failed to construct Command in channel " + channel.getName(), e);
                }
            }

            @Override
            public void terminate(IOException e) {
                receiver.terminate(e);
            }
        });
    }

    @Override
    public final void write(Command cmd, boolean last) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = AnonymousClassWarnings.checkingObjectOutputStream(baos);
        cmd.writeTo(this.channel, oos);
        oos.close();
        byte[] block = baos.toByteArray();
        this.channel.notifyWrite(cmd, block.length);
        this.writeBlock(this.channel, block);
    }

    public static interface ByteArrayReceiver {
        public void handle(byte[] var1);

        public void terminate(IOException var1);
    }
}

