/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.utility;

import com.sumologic.jenkins.jenkinssumologicplugin.model.TestCaseResultModel;
import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.AggregatedTestResultAction;
import java.util.ArrayList;
import java.util.List;

public class TestCaseReport {
    public static List<TestCaseResultModel> getTestCaseReport(Run buildInfo) {
        ArrayList<TestCaseResultModel> testResults = new ArrayList<TestCaseResultModel>();
        if (buildInfo == null) {
            return testResults;
        }
        List testResultActionList = buildInfo.getActions(AbstractTestResultAction.class);
        testResultActionList.forEach(abstractTestResultAction -> {
            if (abstractTestResultAction instanceof AggregatedTestResultAction) {
                testResults.addAll(TestCaseReport.addTestResults((AggregatedTestResultAction)abstractTestResultAction));
            } else if (abstractTestResultAction instanceof TestResultAction) {
                testResults.addAll(TestCaseReport.addTestResult(buildInfo, abstractTestResultAction.getResult()));
            }
        });
        return testResults;
    }

    private static List<TestCaseResultModel> addTestResults(AggregatedTestResultAction testAction) {
        ArrayList<TestCaseResultModel> testResults = new ArrayList<TestCaseResultModel>();
        List childReports = testAction.getChildReports();
        for (AggregatedTestResultAction.ChildReport childReport : childReports) {
            testResults.addAll(TestCaseReport.addTestResult(childReport.run, childReport.result));
        }
        return testResults;
    }

    private static List<TestCaseResultModel> addTestResult(Run run, Object result) {
        ArrayList<TestCaseResultModel> caseResults = new ArrayList<TestCaseResultModel>();
        if (run == null || result == null) {
            return caseResults;
        }
        if (result instanceof TestResult) {
            TestResult result1 = (TestResult)result;
            for (SuiteResult suite : result1.getSuites()) {
                for (CaseResult testCase : suite.getCases()) {
                    if (testCase.isSkipped()) continue;
                    caseResults.add(TestCaseReport.convertTestResult(testCase));
                }
            }
        }
        return caseResults;
    }

    private static TestCaseResultModel convertTestResult(CaseResult testCase) {
        TestCaseResultModel testCaseResultModel = new TestCaseResultModel();
        testCaseResultModel.setClassName(testCase.getClassName());
        testCaseResultModel.setDuration(testCase.getDuration());
        testCaseResultModel.setTestName(testCase.getName());
        testCaseResultModel.setErrorDetails(testCase.getErrorDetails());
        if (testCase.getErrorStackTrace() != null && testCase.getErrorStackTrace().length() > 1010) {
            testCaseResultModel.setErrorStackTrace(testCase.getErrorStackTrace().substring(0, 1000));
        } else {
            testCaseResultModel.setErrorStackTrace(testCase.getErrorStackTrace());
        }
        testCaseResultModel.setStatus(testCase.isFailed() ? "Failed" : "Passed");
        return testCaseResultModel;
    }
}

