/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.sender;

import com.sumologic.jenkins.jenkinssumologicplugin.constants.SumoConstants;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.console.LineTransformationOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;

@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
public class TimestampingOutputStream
extends LineTransformationOutputStream {
    private final OutputStream wrappedStream;

    public TimestampingOutputStream(OutputStream stream) {
        this.wrappedStream = stream;
    }

    public static boolean shouldPutTimestamp(byte[] bytes, int i) {
        String prefix = new String(bytes, 0, Math.min(i, 4), StandardCharsets.UTF_8);
        return prefix.length() > 0 && !Character.isWhitespace(prefix.charAt(0));
    }

    public static byte[] getTimestampAsByteArray(String jobName, String jobNumber) {
        String timeStampStr = "[" + SumoConstants.DATETIME_FORMATTER.format(new Date()) + "]  " + jobName + "#" + jobNumber + " ";
        return timeStampStr.getBytes();
    }

    public static byte[] getTimestampAsByteArray() {
        String timeStampStr = "[" + SumoConstants.DATETIME_FORMATTER.format(new Date()) + "] ";
        return timeStampStr.getBytes();
    }

    protected void eol(byte[] bytes, int i) throws IOException {
        if (TimestampingOutputStream.shouldPutTimestamp(bytes, i)) {
            byte[] timestampBytes = TimestampingOutputStream.getTimestampAsByteArray();
            this.wrappedStream.write(timestampBytes, 0, timestampBytes.length);
        }
        this.wrappedStream.write(bytes, 0, i);
    }
}

