/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.sender;

import com.sumologic.jenkins.jenkinssumologicplugin.PluginDescriptorImpl;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.EventSourceEnum;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.LogTypeEnum;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.SumoConstants;
import com.sumologic.jenkins.jenkinssumologicplugin.model.AgentModel;
import com.sumologic.jenkins.jenkinssumologicplugin.model.BuildModel;
import com.sumologic.jenkins.jenkinssumologicplugin.model.QueueModel;
import com.sumologic.jenkins.jenkinssumologicplugin.sender.LogSenderHelper;
import com.sumologic.jenkins.jenkinssumologicplugin.utility.CommonModelFactory;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.WorkUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.collections.CollectionUtils;

@Extension
public class SumoPeriodicPublisher
extends AsyncPeriodicWork {
    private static final long recurrencePeriod = TimeUnit.MINUTES.toMillis(3L);
    private static final Logger LOGGER = Logger.getLogger(SumoPeriodicPublisher.class.getName());
    private final LogSenderHelper logSenderHelper = LogSenderHelper.getInstance();
    private static Set<String> agentNames = new HashSet<String>();

    private static void setAgents(Set<String> agentNames) {
        SumoPeriodicPublisher.agentNames = agentNames;
    }

    public SumoPeriodicPublisher() {
        super("Sumo Logic Periodic Data Publisher");
        LOGGER.log(Level.FINE, "Sumo Logic status publishing period is {0} ms", recurrencePeriod);
    }

    protected void execute(TaskListener listener) {
        try {
            if (PluginDescriptorImpl.getInstance().isPeriodicLogEnabled()) {
                this.sendNodeDetailsForJenkins();
                this.sendTasksInQueue();
                this.sendRunningJobDetails();
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "An error occurred while sending periodic data ", exception);
        }
    }

    public long getRecurrencePeriod() {
        return recurrencePeriod;
    }

    public void sendTasksInQueue() {
        Queue.Item[] items = Jenkins.get().getQueue().getItems();
        ArrayList<String> queueModels = new ArrayList<String>();
        for (Queue.Item item : items) {
            QueueModel queueModel = new QueueModel();
            queueModel.setLogType(LogTypeEnum.QUEUE_EVENT.getValue());
            queueModel.setQueueId(item.getId());
            queueModel.setQueueTime((float)(System.currentTimeMillis() - item.getInQueueSince()) / 1000.0f);
            queueModel.setBlocked(item.isStuck());
            queueModel.setReasonForBlock(item.getWhy());
            queueModel.setConcurrentBuild(item.task.isConcurrentBuild());
            if (item.task instanceof Job) {
                queueModel.setJobName(((Job)item.task).getFullName());
            } else {
                queueModel.setJobName(item.task.getFullDisplayName());
            }
            queueModel.setJobURL(CommonModelFactory.getAbsoluteUrl(item.task.getUrl()));
            queueModel.setEventTime(SumoConstants.DATETIME_FORMATTER.format(new Date()));
            queueModels.add(queueModel.toString());
        }
        this.logSenderHelper.sendMultiplePeriodicLogs(queueModels);
    }

    public void sendNodeDetailsForJenkins() {
        List<AgentModel> agentModels = CommonModelFactory.getNodeMonitorsDetails();
        if (CollectionUtils.isNotEmpty(agentModels)) {
            ArrayList<String> messages = new ArrayList<String>();
            agentModels.forEach(agentModel -> messages.add(agentModel.toString()));
            this.logSenderHelper.sendMultiplePeriodicLogs(messages);
        }
        Set<String> agentsUp = agentModels.stream().map(AgentModel::getNodeName).collect(Collectors.toSet());
        ArrayList<String> removedAgents = new ArrayList<String>();
        agentNames.forEach(agent -> {
            if (!agentsUp.contains(agent)) {
                AgentModel agentModel = new AgentModel();
                agentModel.setLogType(LogTypeEnum.AGENT_EVENT.getValue());
                agentModel.setEventTime(SumoConstants.DATETIME_FORMATTER.format(new Date()));
                agentModel.setEventSource(EventSourceEnum.PERIODIC_UPDATE.getValue());
                agentModel.setNodeStatus("removed");
                agentModel.setNodeName((String)agent);
                removedAgents.add(agentModel.toString());
            }
        });
        if (CollectionUtils.isNotEmpty(removedAgents)) {
            this.logSenderHelper.sendMultiplePeriodicLogs(removedAgents);
        }
        SumoPeriodicPublisher.setAgents(agentsUp);
    }

    public void sendRunningJobDetails() {
        ArrayList<String> currentBuildDetails = new ArrayList<String>();
        for (Computer computer : Jenkins.get().getComputers()) {
            Run run;
            ArrayList<Run> runList = new ArrayList<Run>();
            for (Executor executor : computer.getExecutors()) {
                run = SumoPeriodicPublisher.getRunningJob(executor);
                if (run == null) continue;
                runList.add(run);
            }
            for (Executor executor : computer.getOneOffExecutors()) {
                run = SumoPeriodicPublisher.getRunningJob(executor);
                if (run == null) continue;
                runList.add(run);
            }
            for (Run run2 : runList) {
                BuildModel buildModel = new BuildModel();
                buildModel.setResult("In_Progress");
                CommonModelFactory.getLabelAndNodeName(run2, buildModel);
                buildModel.setJobBuildURL(CommonModelFactory.getAbsoluteUrl(run2));
                buildModel.setName(run2.getParent().getFullName());
                buildModel.setNumber(run2.getNumber());
                buildModel.setJobRunDuration(CommonModelFactory.getJobRunDuration(run2));
                buildModel.setJobStartTime(SumoConstants.DATETIME_FORMATTER.format(run2.getTimestamp()));
                currentBuildDetails.add(buildModel.toJson());
            }
        }
        if (CollectionUtils.isNotEmpty(currentBuildDetails)) {
            this.logSenderHelper.sendMultiplePeriodicLogs(currentBuildDetails);
        }
    }

    private static Run getRunningJob(Executor executor) {
        Run run = null;
        Queue.Executable executable = executor.getCurrentExecutable();
        WorkUnit workUnit = executor.getCurrentWorkUnit();
        if (executable == null && workUnit != null) {
            executable = workUnit.getExecutable();
        }
        if (executable instanceof Run) {
            run = (Run)executable;
        }
        return run;
    }
}

