/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.sender;

import com.google.gson.Gson;
import com.sumologic.jenkins.jenkinssumologicplugin.sender.LogSenderHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
public class SumoLogicFileUploadStep
extends Step {
    private String file;
    private String includePathPattern;
    private String excludePathPattern;
    private String workingDir;
    private String text;
    private HashMap<String, Object> keyValueMap = new HashMap();
    private HashMap<String, String> fields = new HashMap();

    @DataBoundConstructor
    public SumoLogicFileUploadStep() {
    }

    public String getFile() {
        return this.file;
    }

    @DataBoundSetter
    public void setFile(String file) {
        this.file = file;
    }

    public String getIncludePathPattern() {
        return this.includePathPattern;
    }

    @DataBoundSetter
    public void setIncludePathPattern(String includePathPattern) {
        this.includePathPattern = includePathPattern;
    }

    public String getExcludePathPattern() {
        return this.excludePathPattern;
    }

    @DataBoundSetter
    public void setExcludePathPattern(String excludePathPattern) {
        this.excludePathPattern = excludePathPattern;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    @DataBoundSetter
    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public String getText() {
        return this.text;
    }

    @DataBoundSetter
    public void setText(String text) {
        this.text = text;
    }

    public HashMap<String, Object> getKeyValueMap() {
        return this.keyValueMap;
    }

    @DataBoundSetter
    public void setKeyValueMap(HashMap<String, Object> keyValueMap) {
        this.keyValueMap = keyValueMap;
    }

    public HashMap<String, String> getFields() {
        return this.fields;
    }

    @DataBoundSetter
    public void setFields(HashMap<String, String> fields) {
        this.fields = fields;
    }

    public StepExecution start(StepContext context) {
        return new Execution(this, context);
    }

    private static class Find_File_On_Agent
    extends MasterToSlaveFileCallable<File> {
        protected static final long serialVersionUID = 1L;

        private Find_File_On_Agent() {
        }

        public File invoke(File localFile, VirtualChannel channel) {
            return localFile;
        }
    }

    private static class FileListUploader
    extends MasterToSlaveFileCallable<Void> {
        protected static final long serialVersionUID = 1L;
        private final List<File> fileList;
        private static final LogSenderHelper logSenderHelper = LogSenderHelper.getInstance();
        private final String sourceName;
        private final HashMap<String, String> fields;

        FileListUploader(List<File> fileList, String sourceName, HashMap<String, String> fields) {
            this.fileList = fileList;
            this.sourceName = sourceName;
            this.fields = fields;
        }

        public Void invoke(File f, VirtualChannel channel) throws IOException {
            if (CollectionUtils.isNotEmpty(this.fileList)) {
                for (File dataFile : this.fileList) {
                    this.sendFilesData(dataFile);
                }
            }
            return null;
        }

        public void sendFilesData(File localFile) throws IOException {
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new FileReader(localFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                }
                logSenderHelper.sendFilesData(lines, this.sourceName + "#" + localFile.toURI().toString(), this.fields);
            }
        }
    }

    private static class FileUploader
    extends MasterToSlaveFileCallable<Void> {
        protected static final long serialVersionUID = 1L;
        private static final LogSenderHelper logSenderHelper = LogSenderHelper.getInstance();
        private final String sourceName;
        private final HashMap<String, String> fields;

        FileUploader(String sourceName, HashMap<String, String> fields) {
            this.sourceName = sourceName;
            this.fields = fields;
        }

        public Void invoke(File localFile, VirtualChannel channel) throws IOException {
            Object[] files;
            if (localFile.isFile()) {
                this.sendFilesData(localFile);
            } else if (localFile.isDirectory() && ArrayUtils.isNotEmpty((Object[])(files = localFile.listFiles()))) {
                for (Object dataFile : files) {
                    this.sendFilesData((File)dataFile);
                }
            }
            return null;
        }

        public void sendFilesData(File localFile) throws IOException {
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new FileReader(localFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                }
                logSenderHelper.sendFilesData(lines, this.sourceName + "#" + localFile.toURI().toString(), this.fields);
            }
        }
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<String> {
        protected static final long serialVersionUID = 1L;
        protected final transient SumoLogicFileUploadStep step;
        private static final LogSenderHelper logSenderHelper = LogSenderHelper.getInstance();

        public Execution(SumoLogicFileUploadStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        public void sendTextData(String text, String sourceName, HashMap<String, String> fields) {
            ArrayList<String> lines = new ArrayList<String>();
            if (StringUtils.isNotEmpty((String)text)) {
                lines.add(text);
                logSenderHelper.sendFilesData(lines, sourceName, fields);
            }
        }

        protected String run() throws Exception {
            String file = this.step.getFile();
            String includePathPattern = this.step.getIncludePathPattern();
            String excludePathPattern = this.step.getExcludePathPattern();
            String workingDir = this.step.getWorkingDir();
            String text = this.step.getText();
            HashMap<String, Object> keyValueMap = this.step.getKeyValueMap();
            HashMap<String, String> fields = this.step.getFields();
            if (includePathPattern == null && file == null && text == null && keyValueMap.isEmpty()) {
                throw new Exception("File or IncludePathPattern or Text must not be null");
            }
            if (includePathPattern != null && file != null || includePathPattern != null && text != null || includePathPattern != null && !keyValueMap.isEmpty() || file != null && text != null || file != null && !keyValueMap.isEmpty() || text != null && !keyValueMap.isEmpty()) {
                throw new Exception("File, IncludePathPattern, Text and KeyValueMap cannot be use together");
            }
            FilePath directory = workingDir != null && !"".equals(workingDir.trim()) ? ((FilePath)Objects.requireNonNull(this.getContext().get(FilePath.class))).child(workingDir) : (FilePath)this.getContext().get(FilePath.class);
            if (directory != null) {
                TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
                Run run = (Run)this.getContext().get(Run.class);
                String sourceName = run.getParent().getFullName() + "#" + run.getNumber();
                boolean omitSourcePath = false;
                ArrayList<FilePath> files = new ArrayList<FilePath>();
                if (text != null) {
                    this.sendTextData(text, sourceName, fields);
                    listener.getLogger().println(String.format("Uploaded Text %s to Sumo Logic.", text));
                } else if (!keyValueMap.isEmpty()) {
                    Gson gson = new Gson();
                    String mapString = gson.toJson(keyValueMap);
                    this.sendTextData(mapString, sourceName, fields);
                    listener.getLogger().println(String.format("Uploaded KeyValueMap String %s to Sumo Logic.", mapString));
                } else if (file != null) {
                    files.add(directory.child(file));
                    omitSourcePath = true;
                } else if (excludePathPattern != null && !excludePathPattern.trim().isEmpty()) {
                    files.addAll(Arrays.asList(directory.list(includePathPattern, excludePathPattern, true)));
                } else {
                    files.addAll(Arrays.asList(directory.list(includePathPattern, null, true)));
                }
                if (!files.isEmpty()) {
                    if (omitSourcePath) {
                        FilePath file_name = (FilePath)files.get(0);
                        listener.getLogger().println("Uploading to Sumo Logic with File as " + file_name.toURI());
                        if (!file_name.exists()) {
                            listener.getLogger().println("Upload failed due to missing source file " + file_name.toURI().toString());
                        } else {
                            file_name.act((FilePath.FileCallable)new FileUploader(sourceName, fields));
                            listener.getLogger().println("Upload complete");
                        }
                    } else {
                        ArrayList<File> fileList = new ArrayList<File>();
                        listener.getLogger().println("Uploading to Sumo Logic with Include Path Pattern as " + includePathPattern);
                        for (FilePath child : files) {
                            fileList.add((File)child.act((FilePath.FileCallable)new Find_File_On_Agent()));
                        }
                        directory.act((FilePath.FileCallable)new FileListUploader(fileList, sourceName, fields));
                        listener.getLogger().println("Upload complete for files " + Arrays.toString(fileList.toArray()));
                    }
                    return "Uploaded to Sumo Logic.";
                }
            }
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return new HashSet();
        }

        public String getFunctionName() {
            return "SumoUpload";
        }

        @Nonnull
        public String getDisplayName() {
            return "Upload files or Text to Sumo Logic HTTP source as provided in Sumo Logic Publisher Configuration.";
        }
    }
}

