/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.model;

import com.sumologic.jenkins.jenkinssumologicplugin.PluginDescriptorImpl;
import com.sumologic.jenkins.jenkinssumologicplugin.model.AgentModel;
import com.sumologic.jenkins.jenkinssumologicplugin.model.BuildModel;
import com.sumologic.jenkins.jenkinssumologicplugin.model.JenkinsModel;
import com.sumologic.jenkins.jenkinssumologicplugin.model.MavenModuleBuildModel;
import com.sumologic.jenkins.jenkinssumologicplugin.model.MavenModuleSetBuildModel;
import com.sumologic.jenkins.jenkinssumologicplugin.model.QueueModel;
import com.sumologic.jenkins.jenkinssumologicplugin.utility.CommonModelFactory;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.reporters.SurefireAggregatedReport;
import hudson.model.Computer;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.tasks.test.TestResult;
import java.util.Map;
import jenkins.model.Jenkins;

public class ModelFactory {
    public static JenkinsModel createJenkinsModel(Jenkins jenkins) {
        Queue queue = jenkins.getQueue();
        Queue.Item[] items = queue.getItems();
        long maxwait = 0L;
        long now = System.currentTimeMillis();
        for (Queue.Item item : items) {
            long waiting = now - item.getInQueueSince();
            maxwait = Math.max(maxwait, waiting);
        }
        QueueModel queueModel = new QueueModel();
        int numFreeExecutors = 0;
        for (Computer computer : jenkins.getComputers()) {
            if (!computer.isOnline()) continue;
            numFreeExecutors += computer.countIdle();
        }
        AgentModel agentModel = new AgentModel(jenkins.getNumExecutors(), numFreeExecutors);
        return new JenkinsModel(queueModel, agentModel, jenkins.getDescription());
    }

    public static BuildModel createBuildModel(Run build, PluginDescriptorImpl pluginDescriptor) {
        BuildModel buildModel;
        if (build instanceof MavenModuleSetBuild) {
            MavenModuleSetBuildModel mBuildModel = new MavenModuleSetBuildModel();
            CommonModelFactory.populateGeneric(mBuildModel, build, pluginDescriptor, false);
            MavenModuleSetBuild mbuild = (MavenModuleSetBuild)build;
            SurefireAggregatedReport surefireAggregatedReport = (SurefireAggregatedReport)mbuild.getAction(SurefireAggregatedReport.class);
            if (surefireAggregatedReport != null) {
                mBuildModel.setTotalTestCount(surefireAggregatedReport.getTotalCount());
                mBuildModel.setFailedTestCount(surefireAggregatedReport.getFailCount());
                mBuildModel.setSkippedTestCount(surefireAggregatedReport.getSkipCount());
                for (TestResult result : surefireAggregatedReport.getFailedTests()) {
                    mBuildModel.addFailedTest(result.getDisplayName());
                }
            }
            Map modules = mbuild.getModuleLastBuilds();
            for (MavenBuild module : modules.values()) {
                mBuildModel.addModule((MavenModuleBuildModel)ModelFactory.createBuildModel((Run)module, pluginDescriptor));
            }
            buildModel = mBuildModel;
        } else if (build instanceof MavenBuild) {
            MavenBuild mbuild = (MavenBuild)build;
            MavenModuleBuildModel mBuildModel = new MavenModuleBuildModel();
            CommonModelFactory.populateGeneric(mBuildModel, (Run)mbuild, pluginDescriptor, false);
            buildModel = mBuildModel;
        } else {
            buildModel = new BuildModel();
            CommonModelFactory.populateGeneric(buildModel, build, pluginDescriptor, false);
        }
        return buildModel;
    }
}

