/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.listeners;

import com.sumologic.jenkins.jenkinssumologicplugin.PluginDescriptorImpl;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.AuditEventTypeEnum;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.EventSourceEnum;
import com.sumologic.jenkins.jenkinssumologicplugin.integration.SearchAction;
import com.sumologic.jenkins.jenkinssumologicplugin.model.BuildModel;
import com.sumologic.jenkins.jenkinssumologicplugin.pipeline.SumoPipelineJobStatusGenerator;
import com.sumologic.jenkins.jenkinssumologicplugin.sender.LogSenderHelper;
import com.sumologic.jenkins.jenkinssumologicplugin.utility.CommonModelFactory;
import hudson.Extension;
import hudson.Util;
import hudson.console.ConsoleNote;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.model.listeners.RunListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.CauseOfInterruption;
import jenkins.model.InterruptedBuildAction;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

@Extension
public class SumoPipelineStatusListener
extends RunListener<Run> {
    private static final Logger LOG = Logger.getLogger(SumoPipelineStatusListener.class.getName());
    private static final LogSenderHelper logSenderHelper = LogSenderHelper.getInstance();

    public void onStarted(Run run, TaskListener listener) {
        try {
            String userId = CommonModelFactory.getUserId(run);
            String message = String.format(AuditEventTypeEnum.JOB_STARTED.getMessage(), userId, run.getParent().getFullName(), run.getNumber());
            CommonModelFactory.captureAuditEvent(userId, AuditEventTypeEnum.JOB_STARTED, message, null);
            SumoPipelineStatusListener.updateAgentInfoAfterJobRun(run);
        }
        catch (Exception e) {
            String errorMessage = "Job Status Generation ended with exception as " + e.getMessage();
            LOG.log(Level.WARNING, errorMessage, e);
            listener.error(errorMessage);
        }
    }

    public void onCompleted(Run run, @Nonnull TaskListener listener) {
        try {
            PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
            boolean isSpecificJobFlagEnabled = SumoPipelineStatusListener.isPipeLineJobWithSpecificFlagEnabled(run);
            BuildModel buildModel = SumoPipelineJobStatusGenerator.generateJobStatusInformation(run, pluginDescriptor, isSpecificJobFlagEnabled);
            if (StringUtils.isNotEmpty((String)buildModel.getJobType())) {
                if (pluginDescriptor.isJobStatusLogEnabled() || isSpecificJobFlagEnabled) {
                    logSenderHelper.sendJobStatusLogs(buildModel.toJson());
                }
                if (pluginDescriptor.isJobConsoleLogEnabled() || isSpecificJobFlagEnabled) {
                    run.addAction((Action)new SearchAction(run));
                    CommonModelFactory.sendConsoleLogs(run, listener);
                }
            }
            SumoPipelineStatusListener.updateAgentInfoAfterJobRun(run);
            if (!"ABORTED".equals(buildModel.getResult())) {
                String message = String.format(AuditEventTypeEnum.JOB_FINISHED.getMessage(), run.getParent().getFullName(), run.getNumber(), buildModel.getResult());
                CommonModelFactory.captureAuditEvent(buildModel.getUser(), AuditEventTypeEnum.JOB_FINISHED, message, null);
            }
            List actions = run.getActions(InterruptedBuildAction.class);
            for (InterruptedBuildAction action : actions) {
                List interrupts = Util.filter((List)action.getCauses(), CauseOfInterruption.UserInterruption.class);
                if (interrupts.isEmpty()) continue;
                User user = ((CauseOfInterruption.UserInterruption)interrupts.get(0)).getUser();
                String message = String.format(AuditEventTypeEnum.JOB_ABORTED.getMessage(), user.getId(), run.getParent().getFullName(), run.getNumber());
                CommonModelFactory.captureAuditEvent(user.getId(), AuditEventTypeEnum.JOB_ABORTED, message, null);
            }
        }
        catch (Exception e) {
            String errorMessage = "Job Status Generation ended with exception as " + e.getMessage();
            LOG.log(Level.WARNING, errorMessage, e);
            listener.error(errorMessage);
        }
    }

    private static void updateAgentInfoAfterJobRun(Run buildInfo) {
        Node node;
        BuildModel buildModel = new BuildModel();
        CommonModelFactory.getLabelAndNodeName(buildInfo, buildModel);
        if (buildModel.getNodeName() != null && (node = Jenkins.get().getNode(buildModel.getNodeName())) != null && node.toComputer() != null) {
            Computer computer = node.toComputer();
            CommonModelFactory.updateStatus(computer, EventSourceEnum.PERIODIC_UPDATE.getValue());
        }
    }

    public static boolean isPipeLineJobWithSpecificFlagEnabled(Run run) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(run.getLogReader());){
            AtomicBoolean isFlagEnabled = new AtomicBoolean(false);
            bufferedReader.lines().limit(15L).forEach(value -> {
                String s1 = ConsoleNote.removeNotes((String)value);
                if (s1 != null && s1.contains("[Pipeline] SumoPipelineLogCollection")) {
                    isFlagEnabled.set(true);
                }
            });
            bufferedReader.close();
            boolean bl = isFlagEnabled.get();
            return bl;
        }
    }
}

