/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.listeners;

import com.sumologic.jenkins.jenkinssumologicplugin.PluginDescriptorImpl;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.AuditEventTypeEnum;
import com.sumologic.jenkins.jenkinssumologicplugin.utility.CommonModelFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Item;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.model.listeners.SaveableListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.codec.digest.DigestUtils;

@Extension
@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
public class SumoJobConfigListener
extends SaveableListener {
    private static final Logger LOG = Logger.getLogger(SumoJobConfigListener.class.getName());
    private static final Pattern IGNORED = Pattern.compile("(?:queue|nodeMonitors|UpdateCenter|global-build-stats).xml|/(?:fingerprint|builds|config-history)/.*?xml", 2);
    private final WeakHashMap<String, Integer> cached = new WeakHashMap(512);

    public void onChange(Saveable saveable, XmlFile file) {
        try {
            PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
            if (!pluginDescriptor.isAuditLogEnabled()) {
                return;
            }
            String configPath = file.getFile().getAbsolutePath();
            if (saveable == null || IGNORED.matcher(configPath).find() || "SYSTEM".equals(Jenkins.getAuthentication().getName()) || saveable instanceof User) {
                return;
            }
            String configContent = file.asString();
            String checkSum = DigestUtils.md5Hex((String)(configPath + configContent));
            if (this.cached.containsKey(checkSum)) {
                return;
            }
            this.cached.put(checkSum, 0);
            String encodeFileToString = Base64.getEncoder().encodeToString(file.asString().getBytes());
            String oldFileAsString = null;
            if (pluginDescriptor.isKeepOldConfigData()) {
                File oldFile = SumoJobConfigListener.getOldFile(file);
                byte[] bytes = SumoJobConfigListener.fileToString(oldFile);
                oldFileAsString = Base64.getEncoder().encodeToString(bytes);
                try {
                    Files.copy(file.getFile().toPath(), oldFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "An error occurred while copying the new configuration ", e);
                }
            }
            if (!encodeFileToString.equals(oldFileAsString)) {
                CommonModelFactory.captureConfigChanges(encodeFileToString, oldFileAsString, AuditEventTypeEnum.CHANGES_IN_CONFIG, CommonModelFactory.getRelativeJenkinsHomePath(file.getFile().getAbsolutePath()));
            }
            if (!(saveable instanceof Item)) {
                CommonModelFactory.captureItemAuditEvent(AuditEventTypeEnum.UPDATED, file.getFile().getName(), null);
            }
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "An error occurred while Checking the Job Configuration", exception);
        }
    }

    private static File getOldFile(XmlFile file) {
        File[] files;
        File parentFile;
        File oldFile = null;
        String oldFileName = file.getFile().getName().replace(".xml", "") + "_old.xml";
        String pathForOldFile = file.getFile().getParent() + File.separator + oldFileName;
        if (file.getFile().getParentFile() != null && (parentFile = file.getFile().getParentFile()).listFiles() != null && (files = parentFile.listFiles()) != null) {
            for (File fileNames : files) {
                if (fileNames == null || !fileNames.getName().matches(oldFileName)) continue;
                oldFile = fileNames;
                break;
            }
        }
        if (oldFile == null) {
            oldFile = new File(pathForOldFile);
        }
        return oldFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] fileToString(File file) throws IOException {
        try (BufferedInputStream reader = null;){
            if (file.length() > 0L) {
                int length = (int)file.length();
                reader = new BufferedInputStream(new FileInputStream(file));
                byte[] bytes = new byte[length];
                reader.read(bytes, 0, length);
                reader.close();
                byte[] byArray = bytes;
                return byArray;
            }
        }
        return new byte[0];
    }
}

