/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.jenkins.jenkinssumologicplugin.listeners;

import com.sumologic.jenkins.jenkinssumologicplugin.PluginDescriptorImpl;
import com.sumologic.jenkins.jenkinssumologicplugin.constants.AuditEventTypeEnum;
import com.sumologic.jenkins.jenkinssumologicplugin.utility.CommonModelFactory;
import hudson.Extension;
import javax.annotation.Nonnull;
import jenkins.security.SecurityListener;
import org.acegisecurity.userdetails.UserDetails;

@Extension
public class SumoJenkinsUserLoginListener
extends SecurityListener {
    protected void authenticated(@Nonnull UserDetails details) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isAuditLogEnabled()) {
            CommonModelFactory.captureUserLoginEvent(details.getUsername(), AuditEventTypeEnum.LOGIN);
        }
    }

    protected void failedToAuthenticate(@Nonnull String username) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isAuditLogEnabled()) {
            CommonModelFactory.captureUserLoginEvent(username, AuditEventTypeEnum.LOGIN_FAILURE);
        }
    }

    protected void loggedIn(@Nonnull String username) {
    }

    protected void failedToLogIn(@Nonnull String username) {
    }

    protected void loggedOut(@Nonnull String username) {
        PluginDescriptorImpl pluginDescriptor = PluginDescriptorImpl.getInstance();
        if (pluginDescriptor.isAuditLogEnabled()) {
            CommonModelFactory.captureUserLoginEvent(username, AuditEventTypeEnum.LOGOUT);
        }
    }
}

