/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.subversion;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.Extension;
import hudson.model.Item;
import hudson.scm.CredentialsSVNAuthenticationProviderImpl;
import hudson.scm.FilterSVNAuthenticationManager;
import hudson.scm.SCM;
import hudson.scm.SVNAuthStoreHandlerImpl;
import hudson.scm.SVNAuthenticationManager;
import hudson.scm.SubversionSCM;
import hudson.security.ACL;
import hudson.util.TimeUnit2;
import java.io.File;
import java.io.IOException;
import java.util.List;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.impl.subversion.SubversionSCMFile;
import jenkins.scm.impl.subversion.SubversionSCMSource;
import org.acegisecurity.Authentication;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SubversionSCMFileSystem
extends SCMFileSystem {
    public static final String DISABLE_PROPERTY = SubversionSCMFileSystem.class.getName() + ".disable";
    private SVNRepository repo;

    protected SubversionSCMFileSystem(SVNRepository repo, SCMRevision rev) {
        super(rev);
        this.repo = repo;
    }

    public long lastModified() throws IOException, InterruptedException {
        return this.getRoot().lastModified();
    }

    public SCMFile getRoot() {
        return new SubversionSCMFile(this);
    }

    SVNRepository getRepository() {
        return this.repo;
    }

    public SubversionSCMSource.SCMRevisionImpl getRevision() {
        return (SubversionSCMSource.SCMRevisionImpl)super.getRevision();
    }

    long getLatestRevision() throws SVNException {
        if (this.isFixedRevision()) {
            return this.getRevision().getRevision();
        }
        return this.repo.getLatestRevision();
    }

    public void close() {
        this.repo.closeSession();
    }

    @Extension
    public static class BuilderImpl
    extends SCMFileSystem.Builder {
        public final boolean ENABLED = !"true".equalsIgnoreCase(System.getProperty(DISABLE_PROPERTY));

        public boolean supports(SCM source) {
            return source instanceof SubversionSCM && this.ENABLED;
        }

        public boolean supports(SCMSource source) {
            return source instanceof SubversionSCMSource && this.ENABLED;
        }

        public SCMFileSystem build(SCMSource source, SCMHead head, SCMRevision rev) throws IOException, InterruptedException {
            return this.build((Item)source.getOwner(), source.build(head, rev), rev);
        }

        public SCMFileSystem build(Item owner, SCM scm, SCMRevision rev) throws IOException, InterruptedException {
            if (rev != null && !(rev instanceof SubversionSCMSource.SCMRevisionImpl)) {
                return null;
            }
            try {
                SubversionSCM svn = (SubversionSCM)scm;
                SubversionSCM.ModuleLocation moduleLocation = svn.getLocations()[0];
                StandardCredentials credentials = null;
                SVNURL repoURL = moduleLocation.getSVNURL();
                if (moduleLocation.credentialsId != null) {
                    credentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)repoURL.toString()).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)moduleLocation.credentialsId), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardCredentials.class), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class)})}));
                }
                SVNRepository repository = this.createRepository(repoURL, credentials);
                return new SubversionSCMFileSystem(repository, rev);
            }
            catch (SVNException e) {
                throw new IOException("failed to create SVNRepositoryView", e);
            }
        }

        private SVNRepository createRepository(SVNURL repoURL, StandardCredentials credentials) throws SVNException {
            SVNRepository repository = null;
            repository = SVNRepositoryFactory.create((SVNURL)repoURL);
            File configDir = SVNWCUtil.getDefaultConfigurationDirectory();
            Object sam = new SVNAuthenticationManager(configDir, null, null);
            sam.setAuthenticationProvider(new CredentialsSVNAuthenticationProviderImpl((Credentials)credentials));
            SVNAuthStoreHandlerImpl.install((ISVNAuthenticationManager)sam);
            sam = new FilterSVNAuthenticationManager((ISVNAuthenticationManager)sam){

                @Override
                public int getReadTimeout(SVNRepository repository) {
                    int r = super.getReadTimeout(repository);
                    if (r <= 0) {
                        r = (int)TimeUnit2.MINUTES.toMillis(1L);
                    }
                    return r;
                }
            };
            repository.setTunnelProvider((ISVNTunnelProvider)SVNWCUtil.createDefaultOptions((boolean)true));
            repository.setAuthenticationManager((ISVNAuthenticationManager)sam);
            return repository;
        }
    }
}

