/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.listtagsparameter;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.TaskListener;
import hudson.scm.CredentialsSVNAuthenticationProviderImpl;
import hudson.scm.SubversionSCM;
import hudson.scm.listtagsparameter.ListSubversionTagsParameterValue;
import hudson.scm.listtagsparameter.SimpleSVNDirEntryHandler;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class ListSubversionTagsParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = 1L;
    private final String tagsDir;
    private final String credentialsId;
    private final String tagsFilter;
    private final boolean reverseByDate;
    private final boolean reverseByName;
    private final String defaultValue;
    private final String maxTags;
    private static final String SVN_BRANCHES = "branches";
    private static final String SVN_TAGS = "tags";
    private static final String SVN_TRUNK = "trunk";
    private static final Logger LOGGER = Logger.getLogger(ListSubversionTagsParameterDefinition.class.getName());

    @Deprecated
    public ListSubversionTagsParameterDefinition(String name, String tagsDir, String tagsFilter, String defaultValue, String maxTags, boolean reverseByDate, boolean reverseByName, String uuid) {
        this(name, tagsDir, null, tagsFilter, defaultValue, maxTags, reverseByDate, reverseByName);
    }

    @Deprecated
    public ListSubversionTagsParameterDefinition(String name, String tagsDir, String tagsFilter, String defaultValue, String maxTags, boolean reverseByDate, boolean reverseByName, String uuid, String credentialsId) {
        this(name, tagsDir, credentialsId, tagsFilter, defaultValue, maxTags, reverseByDate, reverseByName);
    }

    @DataBoundConstructor
    public ListSubversionTagsParameterDefinition(String name, String tagsDir, String credentialsId, String tagsFilter, String defaultValue, String maxTags, boolean reverseByDate, boolean reverseByName) {
        super(name, ResourceBundleHolder.get(ListSubversionTagsParameterDefinition.class).format("TagDescription", new Object[0]));
        this.tagsDir = Util.removeTrailingSlash((String)tagsDir);
        this.tagsFilter = tagsFilter;
        this.reverseByDate = reverseByDate;
        this.reverseByName = reverseByName;
        this.defaultValue = defaultValue;
        this.maxTags = maxTags;
        this.credentialsId = credentialsId;
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] values = req.getParameterValues(this.getName());
        if (values == null || values.length != 1) {
            return this.getDefaultParameterValue();
        }
        return new ListSubversionTagsParameterValue(this.getName(), this.getTagsDir(), values[0]);
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject formData) {
        ListSubversionTagsParameterValue value = (ListSubversionTagsParameterValue)((Object)req.bindJSON(ListSubversionTagsParameterValue.class, formData));
        value.setTagsDir(this.getTagsDir());
        return value;
    }

    public ParameterValue createValue(CLICommand command, String value) throws IOException, InterruptedException {
        if (value == null) {
            return this.getDefaultParameterValue();
        }
        return new ListSubversionTagsParameterValue(this.getName(), this.getTagsDir(), value);
    }

    public ParameterValue getDefaultParameterValue() {
        if (StringUtils.isEmpty((String)this.defaultValue)) {
            List<String> tags = this.getTags(null);
            if (tags.size() > 0) {
                return new ListSubversionTagsParameterValue(this.getName(), this.getTagsDir(), tags.get(0));
            }
            return null;
        }
        return new ListSubversionTagsParameterValue(this.getName(), this.getTagsDir(), this.defaultValue);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<String> getTags(@Nullable Job context) {
        Integer max;
        List<Object> dirs = new ArrayList();
        SVNRepository repo = null;
        SVNClientManager clientManager = null;
        try {
            CredentialsSVNAuthenticationProviderImpl authProvider = CredentialsSVNAuthenticationProviderImpl.createAuthenticationProvider((Item)context, this.getTagsDir(), this.getCredentialsId(), null, TaskListener.NULL);
            ISVNAuthenticationManager authManager = SubversionSCM.createSvnAuthenticationManager(authProvider);
            SVNURL repoURL = SVNURL.parseURIDecoded((String)this.getTagsDir());
            repo = SVNRepositoryFactory.create((SVNURL)repoURL);
            repo.setAuthenticationManager(authManager);
            clientManager = SVNClientManager.newInstance(null, (ISVNAuthenticationManager)authManager);
            SVNLogClient logClient = clientManager.getLogClient();
            if (this.isSVNRepositoryProjectRoot(repo)) {
                dirs = this.getSVNRootRepoDirectories(logClient, repoURL);
            } else {
                SimpleSVNDirEntryHandler dirEntryHandler = new SimpleSVNDirEntryHandler(this.tagsFilter);
                logClient.doList(repoURL, SVNRevision.HEAD, SVNRevision.HEAD, false, SVNDepth.IMMEDIATES, 16, (ISVNDirEntryHandler)dirEntryHandler);
                dirs = dirEntryHandler.getDirs(this.isReverseByDate(), this.isReverseByName());
            }
        }
        catch (SVNException e) {
            LOGGER.log(Level.SEVERE, "An SVN exception occurred while listing the directory entries at " + this.getTagsDir(), e);
            List<String> list = Collections.singletonList("!" + ResourceBundleHolder.get(ListSubversionTagsParameterDefinition.class).format("SVNException", new Object[0]));
            return list;
        }
        finally {
            if (repo != null) {
                repo.closeSession();
            }
            if (clientManager != null) {
                clientManager.dispose();
            }
        }
        if (dirs == null) {
            LOGGER.log(Level.INFO, "No directory entries were found for the following SVN repository: {0}", this.getTagsDir());
            return Collections.singletonList("!" + ResourceBundleHolder.get(ListSubversionTagsParameterDefinition.class).format("NoDirectoryEntriesFound", new Object[0]));
        }
        this.removeParentDir(dirs);
        Integer n = max = this.isInt(this.maxTags) ? Integer.valueOf(Integer.parseInt(this.maxTags)) : null;
        if (max != null && dirs.size() > max) {
            dirs = dirs.subList(0, max);
        }
        return dirs;
    }

    public String getTagsDir() {
        return this.tagsDir;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getTagsFilter() {
        return this.tagsFilter;
    }

    public boolean isReverseByDate() {
        return this.reverseByDate;
    }

    public boolean isReverseByName() {
        return this.reverseByName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getMaxTags() {
        return this.maxTags;
    }

    private boolean isSVNRepositoryProjectRoot(SVNRepository repo) {
        try {
            if (repo.info(SVN_TRUNK, SVNRevision.HEAD.getNumber()) != null && repo.info(SVN_BRANCHES, SVNRevision.HEAD.getNumber()) != null && repo.info(SVN_TAGS, SVNRevision.HEAD.getNumber()) != null) {
                return true;
            }
        }
        catch (SVNException e) {
            return false;
        }
        return false;
    }

    private void appendTargetDir(String targetDir, List<String> dirs) {
        if (targetDir != null && dirs != null && dirs.size() > 0) {
            for (int i = 0; i < dirs.size(); ++i) {
                dirs.set(i, targetDir + '/' + dirs.get(i));
            }
        }
    }

    private boolean isInt(String value) {
        boolean isInteger = false;
        try {
            Integer.parseInt(value);
            isInteger = true;
        }
        catch (NumberFormatException e) {
            isInteger = false;
        }
        return isInteger;
    }

    private List<String> getSVNRootRepoDirectories(SVNLogClient logClient, SVNURL repoURL) throws SVNException {
        SVNURL branchesRepo = repoURL.appendPath(SVN_BRANCHES, true);
        SimpleSVNDirEntryHandler branchesEntryHandler = new SimpleSVNDirEntryHandler(null);
        logClient.doList(branchesRepo, SVNRevision.HEAD, SVNRevision.HEAD, false, SVNDepth.IMMEDIATES, -1, (ISVNDirEntryHandler)branchesEntryHandler);
        List<String> branches = branchesEntryHandler.getDirs(this.isReverseByDate(), this.isReverseByName());
        branches.remove("");
        this.appendTargetDir(SVN_BRANCHES, branches);
        SVNURL tagsRepo = repoURL.appendPath(SVN_TAGS, true);
        SimpleSVNDirEntryHandler tagsEntryHandler = new SimpleSVNDirEntryHandler(null);
        logClient.doList(tagsRepo, SVNRevision.HEAD, SVNRevision.HEAD, false, SVNDepth.IMMEDIATES, -1, (ISVNDirEntryHandler)tagsEntryHandler);
        List<String> tags = tagsEntryHandler.getDirs(this.isReverseByDate(), this.isReverseByName());
        tags.remove("");
        this.appendTargetDir(SVN_TAGS, tags);
        ArrayList<String> dirs = new ArrayList<String>();
        dirs.add(SVN_TRUNK);
        dirs.addAll(branches);
        dirs.addAll(tags);
        if (StringUtils.isNotBlank((String)this.tagsFilter) && dirs.size() > 0) {
            Pattern filterPattern = Pattern.compile(this.tagsFilter);
            ArrayList<String> temp = new ArrayList<String>();
            for (String dir : dirs) {
                if (!filterPattern.matcher(dir).matches()) continue;
                temp.add(dir);
            }
            dirs = temp;
        }
        return dirs;
    }

    protected void removeParentDir(List<String> dirs) {
        ArrayList<String> dirsToRemove = new ArrayList<String>();
        for (String dir : dirs) {
            if (!this.getTagsDir().endsWith(dir)) continue;
            dirsToRemove.add(dir);
        }
        dirs.removeAll(dirsToRemove);
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        private SubversionSCM.DescriptorImpl scmDescriptor;

        @Deprecated
        public ISVNAuthenticationProvider createAuthenticationProvider(AbstractProject context) {
            return this.getSubversionSCMDescriptor().createAuthenticationProvider(context);
        }

        @CheckForNull
        public FormValidation doCheckTagsDir(StaplerRequest req, @AncestorInPath Item context, @QueryParameter String value) {
            SubversionSCM.ModuleLocation.DescriptorImpl desc;
            Jenkins instance = Jenkins.getInstance();
            if (instance != null && (desc = (SubversionSCM.ModuleLocation.DescriptorImpl)instance.getDescriptorByType(SubversionSCM.ModuleLocation.DescriptorImpl.class)) != null) {
                return desc.doCheckRemote(req, context, value);
            }
            return FormValidation.warning((String)"Unable to check tags directory.");
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String tagsDir) {
            if (context == null || !context.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel();
            }
            return ((SubversionSCM.ModuleLocation.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(SubversionSCM.ModuleLocation.DescriptorImpl.class)).fillCredentialsIdItems(context, tagsDir);
        }

        @RequirePOST
        public FormValidation doCheckCredentialsId(StaplerRequest req, @AncestorInPath Item context, @QueryParameter String tagsDir, @QueryParameter String value) {
            if (context == null || !context.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            return ((SubversionSCM.ModuleLocation.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(SubversionSCM.ModuleLocation.DescriptorImpl.class)).checkCredentialsId(req, context, tagsDir, value);
        }

        public FormValidation doCheckTagsFilter(@QueryParameter String value) {
            if (value != null && value.length() > 0) {
                try {
                    Pattern.compile(value);
                }
                catch (PatternSyntaxException pse) {
                    return FormValidation.error((String)ResourceBundleHolder.get(ListSubversionTagsParameterDefinition.class).format("NotValidRegex", new Object[0]));
                }
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillTagItems(@AncestorInPath Job<?, ?> context, @QueryParameter String param) {
            ParameterDefinition def;
            ParametersDefinitionProperty prop;
            ListBoxModel model = new ListBoxModel();
            if (context != null && context.hasPermission(Item.BUILD) && (prop = (ParametersDefinitionProperty)context.getProperty(ParametersDefinitionProperty.class)) != null && (def = prop.getParameterDefinition(param)) instanceof ListSubversionTagsParameterDefinition) {
                for (String tag : ((ListSubversionTagsParameterDefinition)def).getTags(context)) {
                    if (tag.startsWith("!")) {
                        model.add(tag.substring(1), "");
                        continue;
                    }
                    model.add(tag);
                }
            }
            return model;
        }

        public String getDisplayName() {
            return ResourceBundleHolder.get(ListSubversionTagsParameterDefinition.class).format("DisplayName", new Object[0]);
        }

        public SubversionSCM.DescriptorImpl getSubversionSCMDescriptor() {
            if (this.scmDescriptor == null) {
                this.scmDescriptor = (SubversionSCM.DescriptorImpl)Hudson.getInstance().getDescriptor(SubversionSCM.class);
            }
            return this.scmDescriptor;
        }
    }
}

