/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.structs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.PluginManager;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import org.codehaus.groovy.tools.Utilities;
import org.jenkinsci.Symbol;
import org.jvnet.hudson.annotation_indexer.Index;

@Extension
public class SymbolLookup {
    private final ConcurrentMap<Key, Object> cache = new ConcurrentHashMap<Key, Object>();
    @Inject
    PluginManager pluginManager;
    @Inject
    Jenkins jenkins;
    private static final Logger LOGGER = Logger.getLogger(SymbolLookup.class.getName());

    public <T> T find(Class<T> type, String symbol) {
        try {
            Key k = new Key("find", type, symbol);
            Object i = this.cache.get(k);
            if (i != null) {
                return type.cast(i);
            }
            if (!Utilities.isJavaIdentifier((String)symbol)) {
                return null;
            }
            for (Class e : Index.list(Symbol.class, (ClassLoader)this.pluginManager.uberClassLoader, Class.class)) {
                Symbol s;
                if (!type.isAssignableFrom(e) || (s = e.getAnnotation(Symbol.class)) == null) continue;
                for (String t : s.value()) {
                    if (!t.equals(symbol)) continue;
                    i = this.jenkins.getInjector().getInstance(e);
                    this.cache.put(k, i);
                    return type.cast(i);
                }
            }
            return null;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to find @Symbol", e);
            return null;
        }
    }

    public <T> Descriptor<? extends T> findDescriptor(Class<T> type, String symbol) {
        try {
            Key k = new Key("findDescriptor", type, symbol);
            Object i = this.cache.get(k);
            if (i != null) {
                return (Descriptor)i;
            }
            if (!Utilities.isJavaIdentifier((String)symbol)) {
                return null;
            }
            for (Class e : Index.list(Symbol.class, (ClassLoader)this.pluginManager.uberClassLoader, Class.class)) {
                Symbol s;
                if (!Descriptor.class.isAssignableFrom(e) || (s = e.getAnnotation(Symbol.class)) == null) continue;
                for (String t : s.value()) {
                    if (!t.equals(symbol)) continue;
                    Descriptor d = (Descriptor)this.jenkins.getInjector().getInstance(e);
                    if (!type.isAssignableFrom(d.clazz)) continue;
                    this.cache.put(k, d);
                    return d;
                }
            }
            return null;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to find @Symbol", e);
            return null;
        }
    }

    public static SymbolLookup get() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            throw new IllegalStateException();
        }
        return (SymbolLookup)j.getInjector().getInstance(SymbolLookup.class);
    }

    @Nonnull
    public static Set<String> getSymbolValue(@Nonnull Object o) {
        if (o instanceof Describable) {
            return SymbolLookup.getSymbolValue(((Describable)o).getDescriptor().getClass());
        }
        return SymbolLookup.getSymbolValue(o.getClass());
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Jenkins.getInstance() can return null in theory.")
    public static Set<String> getSymbolValue(@Nonnull Class<?> c) {
        LinkedHashSet<String> symbolValues = new LinkedHashSet<String>();
        if (Describable.class.isAssignableFrom(c) && !Descriptor.class.isAssignableFrom(c) && Jenkins.getInstance() != null) {
            Descriptor d = Jenkins.getInstance().getDescriptor(c.asSubclass(Describable.class));
            symbolValues.addAll(SymbolLookup.getSymbolValue(d));
        } else {
            Symbol s = c.getAnnotation(Symbol.class);
            if (s != null) {
                Collections.addAll(symbolValues, s.value());
            }
        }
        return symbolValues;
    }

    private static class Key {
        private final String tag;
        private final Class type;
        private final String name;

        public Key(String tag, Class type, String name) {
            this.tag = tag;
            this.type = type;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.type == key.type && this.tag.equals(key.tag) && this.name.equals(key.name);
        }

        public int hashCode() {
            int h = this.type.hashCode();
            h = h * 31 + this.tag.hashCode();
            h = h * 31 + this.name.hashCode();
            return h;
        }
    }
}

