/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsmith.jenkins.stackhammer.validation;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.cloudsmith.jenkins.stackhammer.common.StackOpDescriptor;
import org.cloudsmith.jenkins.stackhammer.validation.Validator;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public final class ValidationDescriptor
extends StackOpDescriptor<Builder> {
    private static final String DEFAULT_SERVICE_URL = "https://stackservice.cloudsmith.com/service/api";
    private static final Integer DEFAULT_POLL_INTERVAL = 15;
    private String serviceURL = "https://stackservice.cloudsmith.com/service/api";
    private Integer pollInterval = DEFAULT_POLL_INTERVAL;
    private Integer maxTime;

    public ValidationDescriptor() {
        super(Validator.class);
        this.load();
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        String pollIntervalParam = ValidationDescriptor.getParameter(formData, "pollInterval");
        this.pollInterval = pollIntervalParam == null ? DEFAULT_POLL_INTERVAL : Integer.valueOf(pollIntervalParam);
        String maxTimeParam = ValidationDescriptor.getParameter(formData, "maxTime");
        this.maxTime = maxTimeParam == null ? null : Integer.valueOf(maxTimeParam);
        String serviceURLParam = ValidationDescriptor.getParameter(formData, "serviceURL");
        this.serviceURL = serviceURLParam == null ? DEFAULT_SERVICE_URL : serviceURLParam;
        this.save();
        return super.configure(req, formData);
    }

    public FormValidation doCheckMaxTime(@QueryParameter String value) throws IOException, ServletException {
        if (value.length() == 0) {
            return FormValidation.ok();
        }
        try {
            Integer intVal = Integer.valueOf(value);
            if (intVal < 30) {
                return FormValidation.error((String)"The timeout must be larger than 30 seconds");
            }
            return FormValidation.ok();
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)"The timeout must be a positive integer value");
        }
    }

    public FormValidation doCheckPollInterval(@QueryParameter String value) throws IOException, ServletException {
        if (value.length() == 0) {
            return FormValidation.ok();
        }
        try {
            Integer intVal = Integer.valueOf(value);
            if (intVal > 0) {
                return FormValidation.ok();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return FormValidation.error((String)"The poll interval must be a positive integer value");
    }

    public FormValidation doCheckServerURL(@QueryParameter String value) throws IOException, ServletException {
        if (value.length() == 0) {
            return FormValidation.ok();
        }
        try {
            URI uri = new URI(value);
            String scheme = uri.getScheme();
            if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"The Service URL must use http or https");
        }
        catch (URISyntaxException e) {
            return FormValidation.error((String)"The Service URL is not syntactially correct: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    public String getDisplayName() {
        return "Stack Hammer Validation";
    }

    public Integer getMaxTime() {
        return this.maxTime;
    }

    public Integer getPollInterval() {
        return this.pollInterval;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }
}

