/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsmith.jenkins.stackhammer.testing;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.tasks.Builder;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.cloudsmith.jenkins.stackhammer.testing.TestRunnerDescriptor;
import org.cloudsmith.jenkins.stackhammer.validation.ValidationDescriptor;
import org.cloudsmith.jenkins.stackhammer.validation.Validator;
import org.cloudsmith.stackhammer.api.Constants;
import org.cloudsmith.stackhammer.api.StackHammerModule;
import org.cloudsmith.stackhammer.api.model.LogEntry;
import org.cloudsmith.stackhammer.api.model.PollResult;
import org.cloudsmith.stackhammer.api.model.Provider;
import org.cloudsmith.stackhammer.api.model.Repository;
import org.cloudsmith.stackhammer.api.model.ResultWithDiagnostic;
import org.cloudsmith.stackhammer.api.model.RunTestsResult;
import org.cloudsmith.stackhammer.api.service.RepositoryService;
import org.cloudsmith.stackhammer.api.service.StackHammerFactory;
import org.cloudsmith.stackhammer.api.service.StackService;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunner
extends Builder {
    private final String branch;
    private final String stack;
    private final String testNames;
    private final Boolean undeploy;
    private final String apiKey;

    @DataBoundConstructor
    public TestRunner(String stack, String branch, String testNames, Boolean undeploy, String apiKey) {
        this.stack = stack;
        this.branch = branch;
        this.testNames = testNames;
        this.undeploy = undeploy;
        this.apiKey = apiKey;
    }

    private void emitLogEntries(List<LogEntry> logEntries, PrintStream logger) {
        for (LogEntry logEntry : logEntries) {
            logger.println(logEntry);
        }
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getBranch() {
        return this.branch;
    }

    public TestRunnerDescriptor getDescriptor() {
        return (TestRunnerDescriptor)super.getDescriptor();
    }

    public String getStack() {
        return this.stack;
    }

    public String getTestNames() {
        return this.testNames;
    }

    public Boolean getUndeploy() {
        return this.undeploy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        try {
            PollResult pollResult;
            Boolean undeployObj;
            long startTime;
            PrintStream logger = listener.getLogger();
            ValidationDescriptor validationDesc = (ValidationDescriptor)Jenkins.getInstance().getDescriptorOrDie(Validator.class);
            String serverURL = validationDesc.getServiceURL();
            URI uri = URI.create(serverURL);
            logger.format("Using parameters%n scheme=%s%n host=%s%n port=%s%n prefix=%s%n", uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath());
            Injector injector = Guice.createInjector((Module[])new Module[]{new StackHammerModule(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath(), this.getApiKey())});
            StackHammerFactory factory = (StackHammerFactory)injector.getInstance(StackHammerFactory.class);
            RepositoryService repoService = factory.createRepositoryService();
            String[] splitName = this.getStack().split("/");
            String owner = splitName[0];
            String name = splitName[1];
            logger.format("Verifying that a local clone of repository %s/%s[%s] exists at Stack Hammer Service%n", owner, name, this.branch);
            ResultWithDiagnostic cloneResult = repoService.cloneRepository(Provider.GITHUB, owner, name, this.branch);
            if (cloneResult.getSeverity() == 4) {
                listener.error(cloneResult.toString());
                return false;
            }
            cloneResult.log(logger);
            StackService stackService = factory.createStackService();
            Repository repo = (Repository)cloneResult.getResult();
            long pollInterval = validationDesc.getPollInterval().longValue();
            long lastPollTime = startTime = System.currentTimeMillis();
            long failTime = Long.MAX_VALUE;
            Integer maxTimeObj = validationDesc.getMaxTime();
            if (maxTimeObj != null && maxTimeObj.longValue() > 0L) {
                failTime = startTime + maxTimeObj.longValue() * 1000L;
            }
            ArrayList<String> testNameList = null;
            if (this.testNames != null) {
                int start = 0;
                int idx = this.testNames.indexOf(44);
                int len = this.testNames.length();
                if (idx < 0) {
                    idx = len;
                }
                while (start < idx) {
                    String testName = this.testNames.substring(start, idx).trim();
                    if (!testName.isEmpty()) {
                        if (testNameList == null) {
                            testNameList = new ArrayList<String>();
                        }
                        testNameList.add(testName);
                    }
                    if ((start = idx + 1) >= len || (idx = this.testNames.indexOf(44, start)) >= 0) continue;
                    idx = len;
                }
            }
            boolean undeploy = (undeployObj = this.getUndeploy()) == null ? false : undeployObj;
            logger.format("Sending order to run tests on stack %s/%s to Stack Hammer Service%n", owner, name);
            String jobIdentifier = stackService.runTests(repo, repo.getOwner() + "/" + repo.getName(), testNameList, undeploy);
            block14: while (true) {
                long now;
                if ((now = System.currentTimeMillis()) > failTime) {
                    logger.format("Job didn't finish in time.%n", new Object[0]);
                    return false;
                }
                long sleepTime = lastPollTime + pollInterval * 1000L - now;
                if (sleepTime > 0L) {
                    Thread.sleep(sleepTime);
                }
                lastPollTime = System.currentTimeMillis();
                pollResult = stackService.pollJob(jobIdentifier);
                switch (pollResult.getJobState()) {
                    case SCHEDULED: 
                    case STARTING: {
                        continue block14;
                    }
                    case SLEEPING: 
                    case RUNNING: {
                        this.emitLogEntries(pollResult.getLogEntries(), logger);
                        continue block14;
                    }
                    case CANCELLED: {
                        listener.error("Job was cancelled");
                        return false;
                    }
                }
                break;
            }
            this.emitLogEntries(pollResult.getLogEntries(), logger);
            RunTestsResult runTestsResult = stackService.getRunTestsResult(jobIdentifier);
            if (runTestsResult == null) {
                listener.error("No result was returned from test run");
                return false;
            }
            if (runTestsResult.getSeverity() == 4) {
                return false;
            }
            String junitXML = (String)runTestsResult.getResult();
            File tmpFile = File.createTempFile("testresult-", ".xml", build.getRootDir());
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), Constants.UTF_8);
                try {
                    writer.write(junitXML);
                }
                finally {
                    ((Writer)writer).close();
                }
                TestResult testResult = new TestResult();
                testResult.parse(tmpFile);
                TestResultAction data = new TestResultAction(build, testResult, listener);
                build.addAction((Action)data);
            }
            finally {
                tmpFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace(listener.error("Exception during deployment of %s", new Object[]{this.getStack()}));
            return false;
        }
        return true;
    }
}

