/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsmith.jenkins.stackhammer.deployment;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.tasks.Builder;
import java.io.PrintStream;
import java.net.URI;
import java.util.List;
import jenkins.model.Jenkins;
import org.cloudsmith.jenkins.stackhammer.deployment.DeploymentDescriptor;
import org.cloudsmith.jenkins.stackhammer.deployment.DeploymentResult;
import org.cloudsmith.jenkins.stackhammer.validation.ValidationDescriptor;
import org.cloudsmith.jenkins.stackhammer.validation.Validator;
import org.cloudsmith.stackhammer.api.StackHammerModule;
import org.cloudsmith.stackhammer.api.model.CatalogGraph;
import org.cloudsmith.stackhammer.api.model.DeployResult;
import org.cloudsmith.stackhammer.api.model.LogEntry;
import org.cloudsmith.stackhammer.api.model.PollResult;
import org.cloudsmith.stackhammer.api.model.Provider;
import org.cloudsmith.stackhammer.api.model.Repository;
import org.cloudsmith.stackhammer.api.model.ResultWithDiagnostic;
import org.cloudsmith.stackhammer.api.service.RepositoryService;
import org.cloudsmith.stackhammer.api.service.StackHammerFactory;
import org.cloudsmith.stackhammer.api.service.StackService;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Deployer
extends Builder {
    private final Boolean dryRun;
    private final String branch;
    private final String stack;
    private final String apiKey;

    @DataBoundConstructor
    public Deployer(String stack, Boolean dryRun, String branch, String apiKey) {
        this.stack = stack;
        this.dryRun = dryRun;
        this.branch = branch;
        this.apiKey = apiKey;
    }

    private void emitLogEntries(List<LogEntry> logEntries, DeploymentResult data, PrintStream logger) {
        for (LogEntry logEntry : logEntries) {
            logger.println(logEntry);
        }
        data.addLogEntries(logEntries);
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getBranch() {
        return this.branch;
    }

    public DeploymentDescriptor getDescriptor() {
        return (DeploymentDescriptor)super.getDescriptor();
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public String getStack() {
        return this.stack;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        try {
            PollResult pollResult;
            Boolean dryRunObj;
            long startTime;
            PrintStream logger = listener.getLogger();
            ValidationDescriptor validationDesc = (ValidationDescriptor)Jenkins.getInstance().getDescriptorOrDie(Validator.class);
            String serverURL = validationDesc.getServiceURL();
            URI uri = URI.create(serverURL);
            logger.format("Using parameters%n scheme=%s%n host=%s%n port=%s%n prefix=%s%n", uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath());
            Injector injector = Guice.createInjector((Module[])new Module[]{new StackHammerModule(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath(), this.getApiKey())});
            DeploymentResult data = new DeploymentResult(build);
            build.addAction((Action)data);
            StackHammerFactory factory = (StackHammerFactory)injector.getInstance(StackHammerFactory.class);
            RepositoryService repoService = factory.createRepositoryService();
            String[] splitName = this.getStack().split("/");
            String owner = splitName[0];
            String name = splitName[1];
            logger.format("Verifying that a local clone of repository %s/%s[%s] exists at Stack Hammer Service%n", owner, name, this.branch);
            ResultWithDiagnostic cloneResult = repoService.cloneRepository(Provider.GITHUB, owner, name, this.branch);
            data.setCloneDiagnostic((ResultWithDiagnostic<Repository>)cloneResult);
            if (cloneResult.getSeverity() == 4) {
                listener.error(cloneResult.toString());
                return false;
            }
            cloneResult.log(logger);
            StackService stackService = factory.createStackService();
            Repository repo = (Repository)cloneResult.getResult();
            long pollInterval = validationDesc.getPollInterval().longValue();
            long lastPollTime = startTime = System.currentTimeMillis();
            long failTime = Long.MAX_VALUE;
            Integer maxTimeObj = validationDesc.getMaxTime();
            if (maxTimeObj != null && maxTimeObj.longValue() > 0L) {
                failTime = startTime + maxTimeObj.longValue() * 1000L;
            }
            boolean dryRun = (dryRunObj = this.getDryRun()) == null ? false : dryRunObj;
            String jobIdentifier = stackService.deployStack(repo, repo.getOwner() + "/" + repo.getName(), dryRun);
            logger.format("Sending order to deploy %s/%s to Stack Hammer Service%n", owner, name);
            block7: while (true) {
                long now;
                if ((now = System.currentTimeMillis()) > failTime) {
                    logger.format("Job didn't finish in time.%n", new Object[0]);
                    return false;
                }
                long sleepTime = lastPollTime + pollInterval * 1000L - now;
                if (sleepTime > 0L) {
                    Thread.sleep(sleepTime);
                }
                lastPollTime = System.currentTimeMillis();
                pollResult = stackService.pollJob(jobIdentifier);
                switch (pollResult.getJobState()) {
                    case SCHEDULED: 
                    case STARTING: {
                        continue block7;
                    }
                    case SLEEPING: 
                    case RUNNING: {
                        this.emitLogEntries(pollResult.getLogEntries(), data, logger);
                        continue block7;
                    }
                    case CANCELLED: {
                        listener.error("Job was cancelled");
                        return false;
                    }
                }
                break;
            }
            this.emitLogEntries(pollResult.getLogEntries(), data, logger);
            DeployResult deploymentResult = stackService.getDeploymentResult(jobIdentifier);
            data.setResult((ResultWithDiagnostic<List<CatalogGraph>>)deploymentResult);
            if (deploymentResult.getSeverity() == 4) {
                listener.error(deploymentResult.toString());
                return false;
            }
            deploymentResult.log(logger);
        }
        catch (Exception e) {
            e.printStackTrace(listener.error("Exception during deployment of %s", new Object[]{this.getStack()}));
            return false;
        }
        return true;
    }
}

