/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsmith.jenkins.stackhammer.common;

import hudson.Functions;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Api;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.cloudsmith.stackhammer.api.model.Diagnostic;
import org.cloudsmith.stackhammer.api.model.MessageWithSeverity;
import org.cloudsmith.stackhammer.api.model.Repository;
import org.cloudsmith.stackhammer.api.model.ResultWithDiagnostic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StackOpResult<T>
implements Action,
Serializable,
Cloneable {
    private static final long serialVersionUID = 264848698476660935L;
    private ResultWithDiagnostic<Repository> cloneDiagnostic;
    private ResultWithDiagnostic<T> resultDiagnostic;
    private final AbstractBuild<?, ?> build;

    protected StackOpResult(AbstractBuild<?, ?> build) {
        this.build = build;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public List<Diagnostic> getCloneDiagnostics() {
        return this.cloneDiagnostic == null ? Collections.emptyList() : this.cloneDiagnostic.getChildren();
    }

    public String getIconFileName() {
        return Functions.getResourcePath() + "/plugin/stackhammer/icons/hammer-32x32.png";
    }

    public String getLargeIconFileName() {
        return "/plugin/stackhammer/icons/hammer-48x48.png";
    }

    protected Repository getRepository() {
        return this.cloneDiagnostic == null ? null : (Repository)this.cloneDiagnostic.getResult();
    }

    public T getResult() {
        return (T)(this.resultDiagnostic == null ? null : this.resultDiagnostic.getResult());
    }

    public List<Diagnostic> getResultDiagnostics() {
        return this.resultDiagnostic == null ? Collections.emptyList() : this.resultDiagnostic.getChildren();
    }

    public int getResultDiagnosticsCount() {
        return this.getResultDiagnostics().size();
    }

    protected String getSummary(List<? extends MessageWithSeverity> messages) {
        int errorCount = 0;
        int warningCount = 0;
        for (MessageWithSeverity messageWithSeverity : messages) {
            switch (messageWithSeverity.getSeverity()) {
                case 3: {
                    ++warningCount;
                    break;
                }
                case 4: 
                case 5: {
                    ++errorCount;
                }
            }
        }
        if (errorCount == 0) {
            if (warningCount == 0) {
                return "No errors or warnings";
            }
            return warningCount + (warningCount > 1 ? " warnings" : " warning");
        }
        if (warningCount == 0) {
            return errorCount + (errorCount > 1 ? " errors" : " error");
        }
        return errorCount + (errorCount > 1 ? " errors and " : " error and ") + warningCount + (warningCount > 1 ? " warnings" : " warning");
    }

    public abstract String getTitle();

    protected String getUrlFor(String item) {
        return this.getUrlName() + '/' + item;
    }

    public void setCloneDiagnostic(ResultWithDiagnostic<Repository> cloneDiagnostic) {
        this.cloneDiagnostic = cloneDiagnostic;
    }

    public void setResult(ResultWithDiagnostic<T> resultDiagnostic) {
        this.resultDiagnostic = resultDiagnostic;
    }
}

