/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.ssh2easy.gssh.client;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import jenkins.plugins.ssh2easy.gssh.GsshPluginException;
import jenkins.plugins.ssh2easy.gssh.GsshUserInfo;
import jenkins.plugins.ssh2easy.gssh.ServerGroup;
import jenkins.plugins.ssh2easy.gssh.client.AbstractSshClient;
import jenkins.plugins.ssh2easy.gssh.client.SshClient;
import org.apache.commons.lang.StringEscapeUtils;

public class DefaultSshClient
extends AbstractSshClient {
    public static final String SSH_BEY = "\nexit $?";
    private String ip;
    private int port;
    private String username;
    private String password;

    public DefaultSshClient(String ip, int port, String username, String password) {
        this.ip = ip;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public DefaultSshClient(ServerGroup serverGroup, String ip) {
        this.port = serverGroup.getPort();
        this.username = serverGroup.getUsername();
        this.password = serverGroup.getPassword();
        this.ip = ip;
    }

    public static SshClient newInstance(String ip, int port, String username, String password) {
        return new DefaultSshClient(ip, port, username, password);
    }

    public static SshClient newInstance(ServerGroup group, String ip) {
        return new DefaultSshClient(group, ip);
    }

    public Session createSession(PrintStream logger) {
        JSch jsch = new JSch();
        Session session = null;
        try {
            session = jsch.getSession(this.username, this.ip, this.port);
            session.setPassword(this.password);
            GsshUserInfo ui = new GsshUserInfo(this.password);
            session.setUserInfo((UserInfo)ui);
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.setDaemonThread(false);
            session.connect();
            logger.println("create ssh session success with ip=[" + this.ip + "],port=[" + this.port + "],username=[" + this.username + "],password=[*******]");
        }
        catch (Exception e) {
            logger.println("create ssh session failed with ip=[" + this.ip + "],port=[" + this.port + "],username=[" + this.username + "],password=[*******]");
            e.printStackTrace(logger);
            throw new GsshPluginException(e);
        }
        return session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int uploadFile(PrintStream logger, String fileName, InputStream fileContent, String serverLocation) {
        int n;
        ChannelSftp sftp;
        Session session;
        block12: {
            session = null;
            sftp = null;
            OutputStream out = null;
            try {
                session = this.createSession(logger);
                Channel channel = session.openChannel("sftp");
                channel.setOutputStream((OutputStream)logger, true);
                channel.setExtOutputStream((OutputStream)logger, true);
                channel.connect();
                Thread.sleep(2000L);
                sftp = (ChannelSftp)channel;
                sftp.setFilenameEncoding("UTF-8");
                sftp.cd(serverLocation);
                out = sftp.put(fileName, 777);
                Thread.sleep(2000L);
                byte[] buffer = new byte[2048];
                int n2 = -1;
                while ((n2 = fileContent.read(buffer, 0, 2048)) != -1) {
                    out.write(buffer, 0, n2);
                }
                out.flush();
                logger.println("upload file [" + fileName + "] to remote [" + serverLocation + "]success");
                n = 0;
                if (sftp != null) {
                    logger.println("[GSSH]-SFTP exit status is " + sftp.getExitStatus());
                }
                if (null == out) break block12;
            }
            catch (Exception e) {
                try {
                    logger.println("[GSSH - SFTP]  Exception:" + e.getMessage());
                    e.printStackTrace(logger);
                    throw new GsshPluginException(e);
                }
                catch (Throwable throwable) {
                    if (sftp != null) {
                        logger.println("[GSSH]-SFTP exit status is " + sftp.getExitStatus());
                    }
                    if (null != out) {
                        try {
                            out.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    this.closeSession(session, (Channel)sftp);
                    throw throwable;
                }
            }
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.closeSession(session, (Channel)sftp);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int downloadFile(PrintStream logger, String remoteFile, String localFolder, String fileName) {
        int n;
        ChannelSftp sftp;
        Session session;
        block11: {
            session = null;
            sftp = null;
            OutputStream out = null;
            try {
                session = this.createSession(logger);
                Channel channel = session.openChannel("sftp");
                channel.connect();
                Thread.sleep(2000L);
                sftp = (ChannelSftp)channel;
                sftp.setFilenameEncoding("UTF-8");
                sftp.get(remoteFile, localFolder + "/" + fileName);
                logger.println("download remote file [" + remoteFile + "] to local [" + localFolder + "] with file name [" + fileName + "]");
                n = 0;
                if (sftp != null) {
                    logger.println("[GSSH]-SFTP exit status is " + sftp.getExitStatus());
                }
                if (null == out) break block11;
            }
            catch (Exception e) {
                try {
                    logger.println("[GSSH - SFTP]  Exception:" + e.getMessage());
                    e.printStackTrace(logger);
                    throw new GsshPluginException(e);
                }
                catch (Throwable throwable) {
                    if (sftp != null) {
                        logger.println("[GSSH]-SFTP exit status is " + sftp.getExitStatus());
                    }
                    if (null != out) {
                        try {
                            out.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    this.closeSession(session, (Channel)sftp);
                    throw throwable;
                }
            }
            try {
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.closeSession(session, (Channel)sftp);
        return n;
    }

    @Override
    public int executeShell(PrintStream logger, String shell) {
        return this.executeCommand(logger, shell);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int executeCommand(PrintStream logger, String command) {
        int n;
        ChannelExec channel;
        Session session;
        block11: {
            session = null;
            channel = null;
            InputStream in = null;
            try {
                String wrapperCommand = this.wrapperInput(command);
                logger.write("execute below commands:".getBytes());
                logger.write(wrapperCommand.getBytes());
                logger.flush();
                session = this.createSession(logger);
                channel = (ChannelExec)session.openChannel("exec");
                channel.setOutputStream((OutputStream)logger, true);
                channel.setExtOutputStream((OutputStream)logger, true);
                channel.setPty(Boolean.FALSE.booleanValue());
                channel.setCommand(wrapperCommand);
                channel.connect();
                Thread.sleep(1000L);
                while (true) {
                    byte[] buffer = new byte[2048];
                    int len = -1;
                    in = channel.getInputStream();
                    while (-1 != (len = in.read(buffer))) {
                        logger.write(buffer, 0, len);
                        logger.flush();
                    }
                    if (channel.isEOF() || !channel.isConnected() || channel.isClosed()) break;
                    Thread.sleep(1000L);
                }
                int status = channel.getExitStatus();
                logger.println("shell exit status code -->" + status);
                n = status;
                if (null == in) break block11;
            }
            catch (Exception e) {
                try {
                    logger.println("[GSSH]-cmd Exception:" + e.getMessage());
                    e.printStackTrace(logger);
                    this.closeSession(session, (Channel)channel);
                    throw new GsshPluginException(e);
                }
                catch (Throwable throwable) {
                    if (null != in) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    this.closeSession(session, (Channel)channel);
                    throw throwable;
                }
            }
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.closeSession(session, (Channel)channel);
        return n;
    }

    @Override
    public boolean testConnection(PrintStream logger) {
        try {
            Session session = this.createSession(logger);
            this.closeSession(session, null);
            return true;
        }
        catch (Exception e) {
            logger.println("test ssh connection failed !");
            e.printStackTrace(logger);
            return false;
        }
    }

    private void closeSession(Session session, Channel channel) {
        if (channel != null) {
            channel.disconnect();
            channel = null;
        }
        if (session != null) {
            session.disconnect();
            session = null;
        }
    }

    protected String wrapperInput(String input) {
        String output = this.fixIEIssue(input);
        return output + SSH_BEY;
    }

    private String fixIEIssue(String input) {
        return StringEscapeUtils.unescapeHtml((String)input);
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        return "Server Info [" + this.ip + " ," + this.port + "," + this.username + "," + this.password + "]";
    }
}

