/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.ssh2easy.acl;

import hudson.security.ACL;
import hudson.security.Permission;
import hudson.security.SidACL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import jenkins.plugins.ssh2easy.acl.Project;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;

public class CloudProject {
    private transient SidACL acl = new CloudAclImpl();
    private final SortedMap<Project, Set<String>> projects;

    CloudProject() {
        this.projects = new TreeMap<Project, Set<String>>();
    }

    CloudProject(SortedMap<Project, Set<String>> projects) {
        this.projects = projects;
    }

    public static CloudProject newInstance() {
        return new CloudProject();
    }

    public static CloudProject newInstance(SortedMap<Project, Set<String>> projects) {
        return new CloudProject(projects);
    }

    private boolean hasPermission(String sid, Permission p) {
        for (Project role : this.listProjectByPermission(p)) {
            if (!((Set)this.projects.get(role)).contains(sid)) continue;
            return true;
        }
        return false;
    }

    public boolean hasProject(Project project) {
        return this.projects.containsKey(project);
    }

    public SidACL getACL() {
        return this.acl;
    }

    public void addProject(Project project) {
        if (null == this.getProject(project.getProjectName())) {
            this.projects.put(project, new HashSet());
        }
    }

    public void addProjectMember(Project project, String userId) {
        if (this.hasProject(project)) {
            ((Set)this.projects.get(project)).add(userId);
        }
    }

    public void clearProjectMembers(Project project) {
        if (this.hasProject(project)) {
            ((Set)this.projects.get(project)).clear();
        }
    }

    public void clearAllProjectMembers() {
        for (Map.Entry<Project, Set<String>> entry : this.projects.entrySet()) {
            Project role = entry.getKey();
            this.clearProjectMembers(role);
        }
    }

    public Project getProject(String name) {
        for (Project project : this.getAllProject()) {
            if (!project.getProjectName().equals(name)) continue;
            return project;
        }
        return null;
    }

    public SortedMap<Project, Set<String>> getAllProjectsPlan() {
        return Collections.unmodifiableSortedMap(this.projects);
    }

    public Set<Project> getAllProject() {
        return Collections.unmodifiableSet(this.projects.keySet());
    }

    public SortedSet<String> getAllMembers() {
        return this.getAllMembers(false);
    }

    public SortedSet<String> getAllMembers(Boolean includeAnonymous) {
        TreeSet<String> members = new TreeSet<String>();
        for (Map.Entry<Project, Set<String>> entry : this.projects.entrySet()) {
            members.addAll(entry.getValue());
        }
        if (!includeAnonymous.booleanValue()) {
            members.remove(((PrincipalSid)ACL.ANONYMOUS).getPrincipal());
        }
        return Collections.unmodifiableSortedSet(members);
    }

    public Set<String> listProjectMembers(String projectName) {
        Project project = this.getProject(projectName);
        if (project != null) {
            return Collections.unmodifiableSet((Set)this.projects.get(project));
        }
        return null;
    }

    public CloudProject newViewAuthorizationStrategyCloudProject(String viewNamePattern) {
        Set<Project> matchedProjects = this.getMatchedViewsProjects(viewNamePattern);
        TreeMap<Project, Set<String>> projectsPlan = new TreeMap<Project, Set<String>>();
        for (Project project : matchedProjects) {
            projectsPlan.put(project, (Set<String>)this.projects.get(project));
        }
        return CloudProject.newInstance(projectsPlan);
    }

    public CloudProject newAuthorizationStrategyCloudProject(String jobNamePattern) {
        Set<Project> matchedProjects = this.getMatchedProjects(jobNamePattern);
        TreeMap<Project, Set<String>> projectsPlan = new TreeMap<Project, Set<String>>();
        for (Project project : matchedProjects) {
            projectsPlan.put(project, (Set<String>)this.projects.get(project));
        }
        return CloudProject.newInstance(projectsPlan);
    }

    private Set<Project> listProjectByPermission(Permission permission) {
        final HashSet<Project> projects = new HashSet<Project>();
        final HashSet<Permission> permissions = new HashSet<Permission>();
        Permission p = permission;
        while (p != null) {
            permissions.add(p);
            p = p.impliedBy;
        }
        new ProjectVisitor(){

            @Override
            public void perform(Project current) {
                if (current.hasAnyPermission(permissions).booleanValue()) {
                    projects.add(current);
                }
            }
        };
        return projects;
    }

    public Set<Project> getMatchedViewsProjects(final String viewNamePattern) {
        final HashSet<Project> projects = new HashSet<Project>();
        new ProjectVisitor(){

            @Override
            public void perform(Project current) {
                Matcher viewNameMatcher = current.getViewNamePattern().matcher(viewNamePattern);
                if (viewNameMatcher.matches()) {
                    projects.add(current);
                }
            }
        };
        return projects;
    }

    private Set<Project> getMatchedProjects(final String jobNamePattern) {
        final HashSet<Project> projects = new HashSet<Project>();
        new ProjectVisitor(){

            @Override
            public void perform(Project current) {
                Matcher jobNameMatcher = current.getJobNamePattern().matcher(jobNamePattern);
                if (jobNameMatcher.matches()) {
                    projects.add(current);
                }
            }
        };
        return projects;
    }

    private abstract class ProjectVisitor {
        ProjectVisitor() {
            this.visit();
        }

        public void visit() {
            Set<Project> projects = CloudProject.this.getAllProject();
            for (Project current : projects) {
                this.perform(current);
            }
        }

        public abstract void perform(Project var1);
    }

    private final class CloudAclImpl
    extends SidACL {
        private CloudAclImpl() {
        }

        protected Boolean hasPermission(Sid p, Permission permission) {
            if (CloudProject.this.hasPermission(this.toString(p), permission)) {
                return true;
            }
            return null;
        }
    }
}

