/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.ssh2easy.acl;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.View;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.SidACL;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.plugins.ssh2easy.acl.CloudProject;
import jenkins.plugins.ssh2easy.acl.Messages;
import jenkins.plugins.ssh2easy.acl.Project;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class CloudCIAuthorizationStrategy
extends AuthorizationStrategy {
    public static final String GLOBAL = AclType.GLOBAL.getType();
    public static final String PROJECT = AclType.PROJECT.getType();
    private final Map<AclType, CloudProject> cloudProjects = new HashMap<AclType, CloudProject>();
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    public static final String ACL_MAP = "aclMap";
    public static final String TYPE = "type";
    public static final String CLOUD_PROJECT = "project";
    public static final String PROJECT_NAME = "projectName";
    public static final String PROJECT_VIEW_NAME_PATTERN = "viewNamePattern";
    public static final String PROJECT_JOB_NAME_PATTERN = "jobNamePattern";
    public static final String PERMISSIONS = "permissions";
    public static final String ASSIGNED_MEMBER_IDS = "assignedMembers";
    public static final String PERMISSION = "permission";
    public static final String MEMBER_ID = "userID";

    public SidACL getRootACL() {
        CloudProject root = this.getCloudProjectByType(AclType.GLOBAL);
        return root.getACL();
    }

    public ACL getACL(final View item) {
        return new ACL(){

            public boolean hasPermission(Authentication a, Permission permission) {
                ACL base = item.getOwner().getACL();
                CloudProject cloudProject = (CloudProject)CloudCIAuthorizationStrategy.this.cloudProjects.get((Object)AclType.PROJECT);
                if (item == null || null == cloudProject) {
                    return true;
                }
                Set<Project> matchedViewProjects = cloudProject.getMatchedViewsProjects(item.getViewName());
                String currentUserId = DescriptorImpl.getCurrentUser();
                for (Project project : matchedViewProjects) {
                    Set<String> members = cloudProject.listProjectMembers(project.getProjectName());
                    if (!members.contains(currentUserId)) continue;
                    if (permission == View.READ) {
                        return base.hasPermission(a, View.CONFIGURE) || !item.getItems().isEmpty();
                    }
                    return base.hasPermission(a, permission);
                }
                return false;
            }
        };
    }

    public ACL getACL(Job<?, ?> project) {
        CloudProject cloudProject = this.cloudProjects.get((Object)AclType.PROJECT);
        SidACL acl = cloudProject == null ? this.getRootACL() : cloudProject.newAuthorizationStrategyCloudProject(project.getName()).getACL().newInheritingACL(this.getRootACL());
        return acl;
    }

    public Collection<String> getGroups() {
        HashSet<String> sids = new HashSet<String>();
        for (Map.Entry<AclType, CloudProject> entry : this.cloudProjects.entrySet()) {
            CloudProject cloudProject = entry.getValue();
            sids.addAll(cloudProject.getAllMembers(true));
        }
        return sids;
    }

    public SortedMap<Project, Set<String>> getProjectPlanMap(String typeString) {
        AclType type = AclType.parseAclType(typeString);
        CloudProject cloudProject = this.getCloudProjectByType(type);
        if (cloudProject != null) {
            return cloudProject.getAllProjectsPlan();
        }
        return null;
    }

    public Set<String> getSIDs(String typeString) {
        AclType type = AclType.parseAclType(typeString);
        CloudProject cloudProject = this.getCloudProjectByType(type);
        if (cloudProject != null) {
            return cloudProject.getAllMembers();
        }
        return null;
    }

    private CloudProject getCloudProjectByType(AclType type) {
        CloudProject cloudProject;
        if (this.cloudProjects.containsKey((Object)type)) {
            cloudProject = this.cloudProjects.get((Object)type);
        } else {
            cloudProject = new CloudProject();
            this.cloudProjects.put(type, cloudProject);
        }
        return cloudProject;
    }

    private Map<AclType, CloudProject> getCloudProjectMaps() {
        return this.cloudProjects;
    }

    private void addProject(AclType type, Project project) {
        CloudProject cloudProject = this.cloudProjects.get((Object)type);
        if (cloudProject != null) {
            cloudProject.addProject(project);
        } else {
            cloudProject = new CloudProject();
            cloudProject.addProject(project);
            this.cloudProjects.put(type, cloudProject);
        }
    }

    private void assignProjectMember(AclType type, Project role, String userId) {
        CloudProject roleMap = this.cloudProjects.get((Object)type);
        if (roleMap != null && roleMap.hasProject(role)) {
            roleMap.addProjectMember(role, userId);
        }
    }

    public static final class DescriptorImpl
    extends GlobalMatrixAuthorizationStrategy.DescriptorImpl {
        public String getDisplayName() {
            return Messages.CloudCIAuthorizationStrategy_DisplayName();
        }

        public void doProjectsSubmit(StaplerRequest req, StaplerResponse rsp) throws UnsupportedEncodingException, ServletException, Descriptor.FormException, IOException {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            req.setCharacterEncoding("UTF-8");
            JSONObject json = req.getSubmittedForm();
            AuthorizationStrategy strategy = this.newInstance(req, json);
            Jenkins.getInstance().setAuthorizationStrategy(strategy);
            Jenkins.getInstance().save();
        }

        public void doAssignSubmit(StaplerRequest req, StaplerResponse rsp) throws UnsupportedEncodingException, ServletException, Descriptor.FormException, IOException {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            req.setCharacterEncoding("UTF-8");
            JSONObject json = req.getSubmittedForm();
            AuthorizationStrategy oldStrategy = Jenkins.getInstance().getAuthorizationStrategy();
            if (json.has(AclType.GLOBAL.getType()) && json.has(AclType.PROJECT.getType()) && oldStrategy instanceof CloudCIAuthorizationStrategy) {
                CloudCIAuthorizationStrategy strategy = (CloudCIAuthorizationStrategy)oldStrategy;
                Map maps = strategy.getCloudProjectMaps();
                for (Map.Entry map : maps.entrySet()) {
                    CloudProject roleMap = (CloudProject)map.getValue();
                    roleMap.clearAllProjectMembers();
                    JSONObject projects = json.getJSONObject(((AclType)((Object)map.getKey())).getType());
                    Set projectDataSet = projects.getJSONObject("data").entrySet();
                    for (Map.Entry r : projectDataSet) {
                        String sid = (String)r.getKey();
                        for (Map.Entry e : ((JSONObject)r.getValue()).entrySet()) {
                            Project role;
                            if (!((Boolean)e.getValue()).booleanValue() || (role = roleMap.getProject((String)e.getKey())) == null || sid == null || sid.equals("")) continue;
                            roleMap.addProjectMember(role, sid);
                        }
                    }
                }
                Jenkins.getInstance().save();
            }
        }

        public AuthorizationStrategy newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            CloudCIAuthorizationStrategy strategy;
            AuthorizationStrategy oldStrategy = Jenkins.getInstance().getAuthorizationStrategy();
            if (formData.has(AclType.GLOBAL.getType()) && formData.has(AclType.PROJECT.getType()) && oldStrategy instanceof CloudCIAuthorizationStrategy) {
                strategy = new CloudCIAuthorizationStrategy();
                JSONObject globalRoles = formData.getJSONObject(AclType.GLOBAL.getType());
                for (Map.Entry r : globalRoles.getJSONObject("data").entrySet()) {
                    Set<String> sids;
                    String roleName = (String)r.getKey();
                    HashSet<Permission> permissions = new HashSet<Permission>();
                    for (Map.Entry e : ((JSONObject)r.getValue()).entrySet()) {
                        if (!((Boolean)e.getValue()).booleanValue()) continue;
                        Permission p = Permission.fromId((String)((String)e.getKey()));
                        permissions.add(p);
                    }
                    Project project = new Project(roleName, permissions);
                    strategy.addProject(AclType.GLOBAL, project);
                    CloudProject roleMap = ((CloudCIAuthorizationStrategy)oldStrategy).getCloudProjectByType(AclType.GLOBAL);
                    if (roleMap == null || (sids = roleMap.listProjectMembers(roleName)) == null) continue;
                    for (String sid : sids) {
                        strategy.assignProjectMember(AclType.GLOBAL, project, sid);
                    }
                }
                JSONObject projectRoles = formData.getJSONObject(AclType.PROJECT.getType());
                for (Map.Entry r : projectRoles.getJSONObject("data").entrySet()) {
                    Set<String> userIds;
                    String roleName = (String)r.getKey();
                    HashSet<Permission> permissions = new HashSet<Permission>();
                    String viewNamePattern = ((JSONObject)r.getValue()).getString(CloudCIAuthorizationStrategy.PROJECT_VIEW_NAME_PATTERN);
                    if (viewNamePattern != null) {
                        ((JSONObject)r.getValue()).remove(CloudCIAuthorizationStrategy.PROJECT_VIEW_NAME_PATTERN);
                    } else {
                        viewNamePattern = ".*";
                    }
                    String jobNamePattern = ((JSONObject)r.getValue()).getString(CloudCIAuthorizationStrategy.PROJECT_JOB_NAME_PATTERN);
                    if (jobNamePattern != null) {
                        ((JSONObject)r.getValue()).remove(CloudCIAuthorizationStrategy.PROJECT_JOB_NAME_PATTERN);
                    } else {
                        jobNamePattern = ".*";
                    }
                    for (Map.Entry e : ((JSONObject)r.getValue()).entrySet()) {
                        if (!((Boolean)e.getValue()).booleanValue()) continue;
                        Permission p = Permission.fromId((String)((String)e.getKey()));
                        permissions.add(p);
                    }
                    Project project = new Project(roleName, viewNamePattern, jobNamePattern, permissions);
                    strategy.addProject(AclType.PROJECT, project);
                    CloudProject roleMap = ((CloudCIAuthorizationStrategy)oldStrategy).getCloudProjectByType(AclType.PROJECT);
                    if (roleMap == null || (userIds = roleMap.listProjectMembers(roleName)) == null) continue;
                    for (String userId : userIds) {
                        strategy.assignProjectMember(AclType.PROJECT, project, userId);
                    }
                }
            } else if (oldStrategy instanceof CloudCIAuthorizationStrategy) {
                strategy = (CloudCIAuthorizationStrategy)oldStrategy;
            } else {
                strategy = new CloudCIAuthorizationStrategy();
                Project adminRole = this.createAdminRole();
                strategy.addProject(AclType.GLOBAL, adminRole);
                strategy.assignProjectMember(AclType.GLOBAL, adminRole, DescriptorImpl.getCurrentUser());
            }
            return strategy;
        }

        public static final String getCurrentUser() {
            PrincipalSid currentUser = new PrincipalSid(Jenkins.getAuthentication());
            return currentUser.getPrincipal();
        }

        private Project createAdminRole() {
            HashSet<Permission> permissions = new HashSet<Permission>();
            for (PermissionGroup group : this.getGroups(AclType.GLOBAL.getType())) {
                for (Permission permission : group) {
                    permissions.add(permission);
                }
            }
            Project role = new Project("admin", permissions);
            return role;
        }

        public List<PermissionGroup> getGroups(String typeString) {
            ArrayList groups;
            AclType type = AclType.parseAclType(typeString);
            switch (type) {
                case GLOBAL: {
                    groups = new ArrayList(PermissionGroup.getAll());
                    groups.remove(PermissionGroup.get(Permission.class));
                    break;
                }
                case PROJECT: {
                    groups = new ArrayList(PermissionGroup.getAll());
                    groups.remove(PermissionGroup.get(Permission.class));
                    groups.remove(PermissionGroup.get(Jenkins.class));
                    groups.remove(PermissionGroup.get(Computer.class));
                    groups.remove(PermissionGroup.get(View.class));
                    break;
                }
                default: {
                    groups = null;
                }
            }
            return groups;
        }

        public boolean showPermission(String typeString, Permission p) {
            AclType type = AclType.parseAclType(typeString);
            switch (type) {
                case GLOBAL: {
                    return this.showPermission(p);
                }
                case PROJECT: {
                    return p != Item.CREATE && p.getEnabled();
                }
            }
            return false;
        }
    }

    public static class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == CloudCIAuthorizationStrategy.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            CloudCIAuthorizationStrategy strategy = (CloudCIAuthorizationStrategy)((Object)source);
            Map maps = strategy.getCloudProjectMaps();
            for (Map.Entry map : maps.entrySet()) {
                CloudProject cloudProject = (CloudProject)map.getValue();
                writer.startNode(CloudCIAuthorizationStrategy.ACL_MAP);
                writer.addAttribute(CloudCIAuthorizationStrategy.TYPE, ((AclType)((Object)map.getKey())).getType());
                for (Map.Entry<Project, Set<String>> projectMap : cloudProject.getAllProjectsPlan().entrySet()) {
                    Project project = projectMap.getKey();
                    if (project == null) continue;
                    writer.startNode(CloudCIAuthorizationStrategy.CLOUD_PROJECT);
                    writer.addAttribute(CloudCIAuthorizationStrategy.PROJECT_NAME, project.getProjectName());
                    writer.addAttribute(CloudCIAuthorizationStrategy.PROJECT_VIEW_NAME_PATTERN, project.getViewNamePattern().pattern());
                    writer.addAttribute(CloudCIAuthorizationStrategy.PROJECT_JOB_NAME_PATTERN, project.getJobNamePattern().pattern());
                    writer.startNode(CloudCIAuthorizationStrategy.PERMISSIONS);
                    for (Permission permission : project.getPermissions()) {
                        writer.startNode(CloudCIAuthorizationStrategy.PERMISSION);
                        writer.setValue(permission.getId());
                        writer.endNode();
                    }
                    writer.endNode();
                    writer.startNode(CloudCIAuthorizationStrategy.ASSIGNED_MEMBER_IDS);
                    for (String sid : projectMap.getValue()) {
                        writer.startNode(CloudCIAuthorizationStrategy.MEMBER_ID);
                        writer.setValue(sid);
                        writer.endNode();
                    }
                    writer.endNode();
                    writer.endNode();
                }
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            CloudCIAuthorizationStrategy strategy = this.create();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if (reader.getNodeName().equals(CloudCIAuthorizationStrategy.ACL_MAP)) {
                    String type = reader.getAttribute(CloudCIAuthorizationStrategy.TYPE);
                    CloudProject map = new CloudProject();
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        String name = reader.getAttribute(CloudCIAuthorizationStrategy.PROJECT_NAME);
                        String viewNamePattern = reader.getAttribute(CloudCIAuthorizationStrategy.PROJECT_VIEW_NAME_PATTERN);
                        String jobNamePattern = reader.getAttribute(CloudCIAuthorizationStrategy.PROJECT_JOB_NAME_PATTERN);
                        HashSet<Permission> permissions = new HashSet<Permission>();
                        String next = reader.peekNextChild();
                        if (next != null && next.equals(CloudCIAuthorizationStrategy.PERMISSIONS)) {
                            reader.moveDown();
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                permissions.add(Permission.fromId((String)reader.getValue()));
                                reader.moveUp();
                            }
                            reader.moveUp();
                        }
                        Project role = new Project(name, viewNamePattern, jobNamePattern, permissions);
                        map.addProject(role);
                        next = reader.peekNextChild();
                        if (next != null && next.equals(CloudCIAuthorizationStrategy.ASSIGNED_MEMBER_IDS)) {
                            reader.moveDown();
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                map.addProjectMember(role, reader.getValue());
                                reader.moveUp();
                            }
                            reader.moveUp();
                        }
                        reader.moveUp();
                    }
                    strategy.cloudProjects.put(AclType.parseAclType(type), map);
                }
                reader.moveUp();
            }
            return strategy;
        }

        protected CloudCIAuthorizationStrategy create() {
            return new CloudCIAuthorizationStrategy();
        }
    }

    private static enum AclType {
        GLOBAL("globalACL"),
        PROJECT("projectACL");

        private String type;

        private AclType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.getType();
        }

        public static AclType parseAclType(String type) {
            for (AclType aclType : AclType.values()) {
                if (!aclType.getType().equals(type)) continue;
                return aclType;
            }
            throw new RuntimeException("Read type from persistent can't recongized from config.xml");
        }
    }
}

