/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserListBoxModel;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.jcraft.jsch.JSchException;
import com.thoughtworks.xstream.XStream;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.jsch.JSchConnector;
import org.jvnet.hudson.plugins.CredentialsSSHSite;
import org.jvnet.hudson.plugins.Messages;
import org.jvnet.hudson.plugins.VariableReplacerUtil;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public final class SSHBuildWrapper
extends BuildWrapper {
    public static final Logger LOGGER = Logger.getLogger(SSHBuildWrapper.class.getName());
    private String siteName;
    private String preScript;
    private String postScript;
    private boolean hideCommand;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public SSHBuildWrapper() {
    }

    @DataBoundConstructor
    public SSHBuildWrapper(String siteName, String preScript, String postScript) {
        this.siteName = siteName;
        this.preScript = preScript;
        this.postScript = postScript;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        BuildWrapper.Environment env = new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                if (!SSHBuildWrapper.this.executePostBuildScript(build, listener)) {
                    return false;
                }
                return super.tearDown(build, listener);
            }
        };
        if (this.executePreBuildScript(build, listener)) {
            return env;
        }
        return null;
    }

    private boolean executePreBuildScript(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        CredentialsSSHSite site = this.getSite();
        if (site == null) {
            listener.getLogger().println("[SSH] No SSH site found - this is likely a configuration problem!");
            build.setResult(Result.UNSTABLE);
            return true;
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.putAll((Map<String, String>)build.getEnvironment((TaskListener)listener));
        vars.putAll(build.getBuildVariables());
        String runtime_cmd = VariableReplacerUtil.preludeWithEnvVars(this.preScript, vars);
        if (this.hideCommand) {
            this.log(logger, "executing pre build script");
        } else {
            this.log(logger, "executing pre build script:\n" + VariableReplacerUtil.scrub(runtime_cmd, vars, build.getSensitiveBuildVariables()));
        }
        if (runtime_cmd != null && !runtime_cmd.trim().equals("")) {
            return site.executeCommand(logger, runtime_cmd) == 0;
        }
        return true;
    }

    private boolean executePostBuildScript(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        CredentialsSSHSite site = this.getSite();
        if (site == null) {
            listener.getLogger().println("[SSH] No SSH site found - this is likely a configuration problem!");
            build.setResult(Result.UNSTABLE);
            return true;
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.putAll((Map<String, String>)build.getEnvironment((TaskListener)listener));
        vars.putAll(build.getBuildVariables());
        String runtime_cmd = VariableReplacerUtil.preludeWithEnvVars(this.postScript, vars);
        if (this.hideCommand) {
            this.log(logger, "executing post build script");
        } else {
            this.log(logger, "executing post build script:\n" + VariableReplacerUtil.scrub(runtime_cmd, vars, build.getSensitiveBuildVariables()));
        }
        if (runtime_cmd != null && !runtime_cmd.trim().equals("")) {
            return site.executeCommand(logger, runtime_cmd) == 0;
        }
        return true;
    }

    public String getPreScript() {
        return this.preScript;
    }

    public void setPreScript(String preScript) {
        this.preScript = preScript;
    }

    public String getPostScript() {
        return this.postScript;
    }

    public void setPostScript(String postScript) {
        this.postScript = postScript;
    }

    public boolean isHideCommand() {
        return this.hideCommand;
    }

    @DataBoundSetter
    public void setHideCommand(boolean hideCommand) {
        this.hideCommand = hideCommand;
    }

    public CredentialsSSHSite getSite() {
        CredentialsSSHSite[] sites;
        for (CredentialsSSHSite site : sites = DESCRIPTOR.getSites()) {
            if (!site.getSitename().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    private void log(PrintStream logger, String message) {
        logger.println(StringUtils.defaultString((String)DESCRIPTOR.getShortName()) + message);
    }

    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        private final CopyOnWriteList<CredentialsSSHSite> sites = new CopyOnWriteList();

        public DescriptorImpl() {
            super(SSHBuildWrapper.class);
            this.load();
        }

        protected DescriptorImpl(Class<? extends BuildWrapper> clazz) {
            super(clazz);
        }

        public String getDisplayName() {
            return Messages.SSH_DisplayName();
        }

        public ListBoxModel doFillSiteNameItems() {
            ListBoxModel m = new ListBoxModel();
            for (CredentialsSSHSite site : DESCRIPTOR.getSites()) {
                m.add(site.getSitename());
            }
            return m;
        }

        public String getShortName() {
            return "[SSH] ";
        }

        public String getHelpFile() {
            return "/plugin/ssh/help.html";
        }

        public BuildWrapper newInstance(StaplerRequest req, JSONObject formData) {
            return (BuildWrapper)req.bindJSON(this.clazz, formData);
        }

        public CredentialsSSHSite[] getSites() {
            return (CredentialsSSHSite[])this.sites.toArray((Object[])new CredentialsSSHSite[0]);
        }

        public FormValidation doCheckHostname(@QueryParameter(value="hostname") String hostname) {
            if (hostname == null || hostname.trim().isEmpty()) {
                return FormValidation.error((String)"Hostname not specified!");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCredentialId(@QueryParameter(value="credentialId") String credentialId) {
            if (credentialId == null || credentialId.trim().isEmpty()) {
                return FormValidation.error((String)"Credential not selected!");
            }
            return FormValidation.ok();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            List sitesFromRequest = req.bindJSONToList(CredentialsSSHSite.class, formData.get("sites"));
            Iterator iter = sitesFromRequest.iterator();
            while (iter.hasNext()) {
                CredentialsSSHSite sshSite = (CredentialsSSHSite)iter.next();
                if (!StringUtils.isBlank((String)sshSite.getHostname()) && !StringUtils.isBlank((String)sshSite.getCredentialId())) continue;
                iter.remove();
            }
            this.sites.replaceBy((Collection)sitesFromRequest);
            this.save();
            return true;
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath ItemGroup<?> context) {
            List credentials = CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, context, (Authentication)ACL.SYSTEM, CredentialsSSHSite.NO_REQUIREMENTS);
            return new SSHUserListBoxModel().withEmptySelection().withMatching(SSHAuthenticator.matcher(JSchConnector.class), (Iterable)credentials);
        }

        public FormValidation doLoginCheck(@QueryParameter(value="hostname") String hostname, @QueryParameter(value="port") String port, @QueryParameter(value="credentialId") String credentialId, @QueryParameter(value="serverAliveInterval") String serverAliveInterval, @QueryParameter(value="timeout") String timeout) {
            hostname = Util.fixEmpty((String)hostname);
            port = Util.fixEmpty((String)port);
            credentialId = Util.fixEmpty((String)credentialId);
            if (hostname == null || port == null || credentialId == null) {
                return FormValidation.warning((String)"Please fill host, port and credentials.");
            }
            CredentialsSSHSite site = new CredentialsSSHSite(hostname, port, credentialId, serverAliveInterval, timeout);
            try {
                try {
                    site.testConnection(System.out);
                }
                catch (JSchException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage());
                    throw new IOException("Can't connect to server");
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
                return FormValidation.error((String)e.getMessage());
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok((String)"Successfull connection");
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        protected XmlFile getConfigFile() {
            XStream2 customXstream = new XStream2();
            customXstream.addCompatibilityAlias("org.jvnet.hudson.plugins.SSHSite", CredentialsSSHSite.LegacySSHSite.class);
            return new XmlFile((XStream)customXstream, new File(Jenkins.getInstance().getRootDir(), this.getId() + ".xml"));
        }

        private Object readResolve() {
            boolean madeChanges = false;
            ArrayList<CredentialsSSHSite> migratedCredentials = new ArrayList<CredentialsSSHSite>(this.sites.size());
            for (CredentialsSSHSite site : this.sites) {
                try {
                    CredentialsSSHSite migrated = CredentialsSSHSite.migrateToCredentials(site);
                    migratedCredentials.add(migrated);
                    madeChanges = madeChanges || migrated != site;
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Failed to migrate site: " + site, e);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to migrate site: " + site, e);
                }
            }
            if (madeChanges) {
                this.sites.replaceBy(migratedCredentials);
            }
            return this;
        }
    }
}

