/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.verifiers;

import hudson.Extension;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.plugins.sshslaves.verifiers.HostKey;
import hudson.plugins.sshslaves.verifiers.KeyParseException;
import hudson.plugins.sshslaves.verifiers.SshHostKeyVerificationStrategy;
import hudson.plugins.sshslaves.verifiers.TrileadVersionSupportManager;
import hudson.remoting.Base64;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.StringTokenizer;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ManuallyProvidedKeyVerificationStrategy
extends SshHostKeyVerificationStrategy {
    private final HostKey key;

    @DataBoundConstructor
    public ManuallyProvidedKeyVerificationStrategy(String key) {
        try {
            this.key = ManuallyProvidedKeyVerificationStrategy.parseKey(key);
        }
        catch (KeyParseException e) {
            throw new IllegalArgumentException("Invalid key: " + e.getMessage(), e);
        }
    }

    public String getKey() {
        return this.key.getAlgorithm() + " " + Base64.encode((byte[])this.key.getKey());
    }

    public HostKey getParsedKey() {
        return this.key;
    }

    @Override
    public boolean verify(SlaveComputer computer, HostKey hostKey, TaskListener listener) throws Exception {
        if (this.key.equals(hostKey)) {
            listener.getLogger().println(Messages.ManualKeyProvidedHostKeyVerifier_KeyTrusted(SSHLauncher.getTimestamp()));
            return true;
        }
        listener.getLogger().println(Messages.ManualKeyProvidedHostKeyVerifier_KeyNotTrusted(SSHLauncher.getTimestamp()));
        return false;
    }

    @Override
    public String[] getPreferredKeyAlgorithms(SlaveComputer computer) throws IOException {
        String[] unsortedAlgorithms = super.getPreferredKeyAlgorithms(computer);
        ArrayList<String> sortedAlgorithms = new ArrayList<String>(unsortedAlgorithms != null ? Arrays.asList(unsortedAlgorithms) : Collections.emptyList());
        sortedAlgorithms.remove(this.key.getAlgorithm());
        sortedAlgorithms.add(0, this.key.getAlgorithm());
        return sortedAlgorithms.toArray(new String[sortedAlgorithms.size()]);
    }

    private static HostKey parseKey(String key) throws KeyParseException {
        if (!key.contains(" ")) {
            throw new IllegalArgumentException(Messages.ManualKeyProvidedHostKeyVerifier_TwoPartKey());
        }
        StringTokenizer tokenizer = new StringTokenizer(key, " ");
        String algorithm = tokenizer.nextToken();
        byte[] keyValue = Base64.decode((String)tokenizer.nextToken());
        if (null == keyValue) {
            throw new KeyParseException(Messages.ManualKeyProvidedHostKeyVerifier_Base64EncodedKeyValueRequired());
        }
        return TrileadVersionSupportManager.getTrileadSupport().parseKey(algorithm, keyValue);
    }

    @Extension
    public static class ManuallyProvidedKeyVerificationStrategyDescriptor
    extends SshHostKeyVerificationStrategy.SshHostKeyVerificationStrategyDescriptor {
        public String getDisplayName() {
            return Messages.ManualKeyProvidedHostKeyVerifier_DisplayName();
        }

        public FormValidation doCheckKey(@QueryParameter String key) {
            try {
                ManuallyProvidedKeyVerificationStrategy.parseKey(key);
                return FormValidation.ok();
            }
            catch (KeyParseException ex) {
                return FormValidation.error((String)ex.getMessage());
            }
        }
    }
}

