/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.verifiers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Computer;
import hudson.model.TaskAction;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.verifiers.HostKey;
import hudson.plugins.sshslaves.verifiers.HostKeyHelper;
import hudson.security.ACL;
import hudson.security.Permission;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class TrustHostKeyAction
extends TaskAction {
    private static int keyNumber = 0;
    private final HostKey hostKey;
    private final Computer computer;
    private final String actionPath;
    private boolean complete;

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Need a static counter of all instances that have been created")
    TrustHostKeyAction(Computer computer, HostKey hostKey) {
        this.hostKey = hostKey;
        this.computer = computer;
        this.actionPath = "saveHostKey-" + keyNumber++;
    }

    public HostKey getHostKey() {
        return this.hostKey;
    }

    public HostKey getExistingHostKey() throws IOException {
        return HostKeyHelper.getInstance().getHostKey(this.getComputer());
    }

    public Computer getComputer() {
        return this.computer;
    }

    @RequirePOST
    public void doSubmit(StaplerRequest request, StaplerResponse response) throws IOException, ServletException {
        this.getACL().checkPermission(this.getPermission());
        if (null != request.getParameter("Yes")) {
            HostKeyHelper.getInstance().saveHostKey(this.getComputer(), this.getHostKey());
        } else if (null == request.getParameter("No")) {
            throw new IOException("Invalid action");
        }
        this.complete = true;
        response.sendRedirect("../");
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        req.getView((Object)this, "trustHostKey").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String getIconFileName() {
        if (this.complete || !this.getACL().hasPermission(this.getPermission())) {
            return null;
        }
        return "save.gif";
    }

    public String getDisplayName() {
        if (this.complete || !this.getACL().hasPermission(this.getPermission())) {
            return null;
        }
        return Messages.TrustHostKeyAction_DisplayName();
    }

    protected Permission getPermission() {
        return Computer.CONFIGURE;
    }

    protected ACL getACL() {
        return this.computer.getACL();
    }

    public String getUrlName() {
        if (this.complete || !this.getACL().hasPermission(this.getPermission())) {
            return null;
        }
        return this.actionPath;
    }
}

