/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.verifiers;

import com.trilead.ssh2.signature.DSASHA1Verify;
import com.trilead.ssh2.signature.RSASHA1Verify;
import hudson.Extension;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.plugins.sshslaves.verifiers.HostKey;
import hudson.plugins.sshslaves.verifiers.SshHostKeyVerificationStrategy;
import hudson.remoting.Base64;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.StringTokenizer;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ManuallyProvidedKeyVerificationStrategy
extends SshHostKeyVerificationStrategy {
    private final HostKey key;

    @DataBoundConstructor
    public ManuallyProvidedKeyVerificationStrategy(String key) {
        this.key = ManuallyProvidedKeyVerificationStrategy.parseKey(key);
    }

    public String getKey() {
        return this.key.getAlgorithm() + " " + Base64.encode((byte[])this.key.getKey());
    }

    public HostKey getParsedKey() {
        return this.key;
    }

    @Override
    public boolean verify(SlaveComputer computer, HostKey hostKey, TaskListener listener) throws Exception {
        if (this.key.equals(hostKey)) {
            listener.getLogger().println(Messages.ManualKeyProvidedHostKeyVerifier_KeyTrusted(SSHLauncher.getTimestamp()));
            return true;
        }
        listener.getLogger().println(Messages.ManualKeyProvidedHostKeyVerifier_KeyNotTrusted(SSHLauncher.getTimestamp()));
        return false;
    }

    private static HostKey parseKey(String key) {
        byte[] keyValue;
        String algorithm;
        block7: {
            if (!key.contains(" ")) {
                throw new IllegalArgumentException(Messages.ManualKeyProvidedHostKeyVerifier_TwoPartKey());
            }
            StringTokenizer tokenizer = new StringTokenizer(key, " ");
            algorithm = tokenizer.nextToken();
            keyValue = Base64.decode((String)tokenizer.nextToken());
            if (null == keyValue) {
                throw new IllegalArgumentException(Messages.ManualKeyProvidedHostKeyVerifier_Base64EncodedKeyValueRequired());
            }
            try {
                if ("ssh-rsa".equals(algorithm)) {
                    RSASHA1Verify.decodeSSHRSAPublicKey((byte[])keyValue);
                    break block7;
                }
                if ("ssh-dss".equals(algorithm)) {
                    DSASHA1Verify.decodeSSHDSAPublicKey((byte[])keyValue);
                    break block7;
                }
                throw new IllegalArgumentException("Key algorithm should be one of ssh-rsa or ssh-dss");
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(Messages.ManualKeyProvidedHostKeyVerifier_KeyValueDoesNotParse(algorithm), ex);
            }
            catch (StringIndexOutOfBoundsException ex) {
                throw new IllegalArgumentException(Messages.ManualKeyProvidedHostKeyVerifier_KeyValueDoesNotParse(algorithm), ex);
            }
        }
        return new HostKey(algorithm, keyValue);
    }

    @Extension
    public static class ManuallyProvidedKeyVerificationStrategyDescriptor
    extends SshHostKeyVerificationStrategy.SshHostKeyVerificationStrategyDescriptor {
        public String getDisplayName() {
            return Messages.ManualKeyProvidedHostKeyVerifier_DisplayName();
        }

        public FormValidation doCheckKey(@QueryParameter String key) {
            try {
                ManuallyProvidedKeyVerificationStrategy.parseKey(key);
                return FormValidation.ok();
            }
            catch (IllegalArgumentException ex) {
                return FormValidation.error((String)ex.getMessage());
            }
        }
    }
}

