/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.verifiers;

import com.trilead.ssh2.KnownHosts;
import hudson.Extension;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.plugins.sshslaves.verifiers.HostKey;
import hudson.plugins.sshslaves.verifiers.SshHostKeyVerificationStrategy;
import hudson.slaves.SlaveComputer;
import java.io.File;
import org.kohsuke.stapler.DataBoundConstructor;

public class KnownHostsFileKeyVerificationStrategy
extends SshHostKeyVerificationStrategy {
    private static final File KNOWN_HOSTS_FILE = new File(new File(new File(System.getProperty("user.home")), ".ssh"), "known_hosts");

    @DataBoundConstructor
    public KnownHostsFileKeyVerificationStrategy() {
    }

    @Override
    public boolean verify(SlaveComputer computer, HostKey hostKey, TaskListener listener) throws Exception {
        if (!KNOWN_HOSTS_FILE.exists()) {
            listener.getLogger().println(Messages.KnownHostsFileHostKeyVerifier_NoKnownHostsFile(KNOWN_HOSTS_FILE.getAbsolutePath()));
            return false;
        }
        KnownHosts knownHosts = new KnownHosts(KNOWN_HOSTS_FILE);
        int result = knownHosts.verifyHostkey(((SSHLauncher)computer.getLauncher()).getHost(), hostKey.getAlgorithm(), hostKey.getKey());
        if (0 == result) {
            listener.getLogger().println(Messages.KnownHostsFileHostKeyVerifier_KeyTrused(SSHLauncher.getTimestamp()));
            return true;
        }
        if (1 == result) {
            listener.getLogger().println(Messages.KnownHostsFileHostKeyVerifier_NewKeyNotTrusted(SSHLauncher.getTimestamp()));
            return false;
        }
        listener.getLogger().println(Messages.KnownHostsFileHostKeyVerifier_ChangedKeyNotTrusted(SSHLauncher.getTimestamp()));
        return false;
    }

    @Extension
    public static class KnownHostsFileKeyVerificationStrategyDescriptor
    extends SshHostKeyVerificationStrategy.SshHostKeyVerificationStrategyDescriptor {
        public String getDisplayName() {
            return Messages.KnownHostsFileHostKeyVerifier_DisplayName();
        }
    }
}

