/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshagent.mina;

import com.cloudbees.jenkins.plugins.sshagent.Messages;
import com.cloudbees.jenkins.plugins.sshagent.RemoteAgent;
import hudson.model.TaskListener;
import java.io.Closeable;
import java.io.IOException;
import java.security.KeyPair;
import jenkins.bouncycastle.api.PEMEncodable;
import org.apache.commons.io.IOUtils;
import org.apache.sshd.agent.unix.AgentServer;

public class MinaRemoteAgent
implements RemoteAgent {
    private final AgentServer agent;
    private final String socket;
    private final TaskListener listener;

    public MinaRemoteAgent(TaskListener listener) throws Exception {
        this.listener = listener;
        this.agent = new AgentServer();
        this.socket = this.agent.start();
    }

    @Override
    public String getSocket() {
        return this.socket;
    }

    @Override
    public void addIdentity(String privateKey, String passphrase, String comment) throws IOException {
        try {
            KeyPair keyPair = PEMEncodable.decode((String)privateKey, (char[])(passphrase == null ? null : passphrase.toCharArray())).toKeyPair();
            this.agent.getAgent().addIdentity(keyPair, comment);
        }
        catch (Exception e) {
            e.printStackTrace(this.listener.error(Messages.SSHAgentBuildWrapper_UnableToReadKey(e.getMessage())));
        }
    }

    @Override
    public void stop() {
        IOUtils.closeQuietly((Closeable)this.agent);
    }
}

