/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshagent.jna;

import com.cloudbees.jenkins.plugins.sshagent.Messages;
import com.cloudbees.jenkins.plugins.sshagent.RemoteAgent;
import com.cloudbees.jenkins.plugins.sshagent.jna.AgentServer;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import javax.annotation.CheckForNull;
import jenkins.bouncycastle.api.PEMEncodable;

public class JNRRemoteAgent
implements RemoteAgent {
    private final AgentServer agent;
    private final String socket;
    private final TaskListener listener;

    public JNRRemoteAgent(TaskListener listener, @CheckForNull File temp) throws Exception {
        this.listener = listener;
        this.agent = new AgentServer(temp);
        this.socket = this.agent.start();
    }

    @Override
    public String getSocket() {
        return this.socket;
    }

    @Override
    public void addIdentity(String privateKey, String passphrase, String comment) throws IOException {
        try {
            KeyPair keyPair = PEMEncodable.decode((String)privateKey, (char[])(passphrase == null ? null : passphrase.toCharArray())).toKeyPair();
            this.agent.getAgent().addIdentity(keyPair, comment);
        }
        catch (Exception e) {
            this.listener.getLogger().println(Messages.SSHAgentBuildWrapper_UnableToReadKey(e.getMessage()));
            e.printStackTrace(this.listener.getLogger());
        }
    }

    @Override
    public void stop() {
        this.agent.close();
    }
}

