/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.controller;

import com.hello2morrow.sonargraph.integration.jenkins.controller.AbstractHTMLAction;
import com.hello2morrow.sonargraph.integration.jenkins.controller.ConfigParameters;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public final class SonargraphBuildAction
extends AbstractHTMLAction {
    private final AbstractBuild<?, ?> build;

    public SonargraphBuildAction(AbstractBuild<?, ?> build) {
        this.build = build;
    }

    @Override
    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        FilePath reportHistoryDir = new FilePath(new FilePath(this.build.getProject().getRootDir()), ConfigParameters.REPORT_HISTORY_FOLDER.getValue());
        this.enableDirectoryBrowserSupport(req, rsp, new FilePath(reportHistoryDir, "sonargraph-report-build-" + this.build.getNumber()));
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public String getIconFileName() {
        return ConfigParameters.SONARGRAPH_ICON.getValue();
    }

    public String getDisplayName() {
        return ConfigParameters.ACTION_DISPLAY_NAME.getValue();
    }

    public String getUrlName() {
        return ConfigParameters.HTML_REPORT_ACTION_URL.getValue();
    }

    @Override
    public String getHTMLReport() throws IOException, InterruptedException {
        File projectRootFolder = this.build.getProject().getRootDir();
        File reportHistoryFolder = new File(projectRootFolder, ConfigParameters.REPORT_HISTORY_FOLDER.getValue());
        File reportBuildFolder = new File(reportHistoryFolder, "sonargraph-report-build-" + this.build.getNumber());
        String reportFileName = ConfigParameters.SONARGRAPH_HTML_REPORT_FILE_NAME.getValue() + ".html";
        File reportFile = new File(reportBuildFolder, reportFileName);
        return this.readHTMLReport(new FilePath(reportFile));
    }
}

