/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.controller;

import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.TextFileReader;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class AbstractHTMLAction
implements Action {
    protected void enableDirectoryBrowserSupport(StaplerRequest req, StaplerResponse rsp, FilePath directoryToServe) throws IOException, ServletException {
        DirectoryBrowserSupport directoryBrowser = new DirectoryBrowserSupport((ModelObject)this, directoryToServe, this.getDisplayName() + "html2", "graph.gif", false);
        SonargraphLogger.INSTANCE.log(Level.FINE, "AbstractHTMLAction.enableDirectoryBrowserSupport for directory " + directoryToServe.getRemote());
        directoryBrowser.generateResponse(req, rsp, (Object)this);
    }

    protected String readHTMLReport(FilePath pathToReport) throws IOException, InterruptedException {
        String htmlReport;
        SonargraphLogger.INSTANCE.log(Level.INFO, "Reading Sonargraph HTML Report from '" + pathToReport + "'");
        if (pathToReport.exists()) {
            htmlReport = TextFileReader.readLargeTextFile(pathToReport);
        } else {
            SonargraphLogger.INSTANCE.log(Level.WARNING, "Unable to read Sonargraph HTML report from '" + pathToReport + "'");
            htmlReport = "Unable to read Sonargraph HTML report.";
        }
        return htmlReport;
    }

    public abstract void doDynamic(StaplerRequest var1, StaplerResponse var2) throws IOException, ServletException;

    public abstract String getHTMLReport() throws IOException, InterruptedException;
}

