/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.utils;

import hudson.console.LineTransformationOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class MaskPasswordsOutputStream
extends LineTransformationOutputStream {
    private static final String REPLACEMENT = "******";
    private static final String URL_IN_LOGS = "ANALYSIS SUCCESSFUL, you can browse ";
    private final OutputStream logger;
    private final Pattern passwordsAsPattern;
    private final Charset charset;

    public MaskPasswordsOutputStream(OutputStream logger, Charset charset, Collection<String> passwords) {
        this.logger = logger;
        this.charset = charset;
        if (!passwords.isEmpty()) {
            StringBuilder regex = new StringBuilder().append('(');
            int nbMaskedPasswords = 0;
            for (String password : passwords) {
                if (!StringUtils.isNotEmpty((String)password)) continue;
                regex.append(Pattern.quote(password));
                regex.append('|');
                ++nbMaskedPasswords;
            }
            if (nbMaskedPasswords >= 1) {
                regex.deleteCharAt(regex.length() - 1);
                regex.append(')');
                this.passwordsAsPattern = Pattern.compile(regex.toString());
            } else {
                this.passwordsAsPattern = null;
            }
        } else {
            this.passwordsAsPattern = null;
        }
    }

    protected void eol(byte[] bytes, int len) throws IOException {
        String line = this.charset.decode(ByteBuffer.wrap(bytes, 0, len)).toString();
        if (this.passwordsAsPattern != null && !line.contains(URL_IN_LOGS)) {
            line = this.passwordsAsPattern.matcher(line).replaceAll(REPLACEMENT);
        }
        this.logger.write(line.getBytes(this.charset));
    }

    public void close() throws IOException {
        super.close();
        this.logger.close();
    }
}

